# گانت چارت پروژه HajiBot
## نقشه‌راه کامل تا لانچ (Production-Ready)

### 📊 خلاصه اجرایی
- **مدت کل پروژه**: 8-12 هفته
- **تاریخ شروع**: هفته جاری
- **تاریخ لانچ هدف**: 10-14 هفته آینده
- **وضعیت فعلی**: 60-70% تکمیل شده

---

## 🗓️ گانت چارت تفصیلی

### **فاز 1: زیرساخت و امنیت (هفته 1-2)**
```
Task                          Week 1    Week 2    Dependencies    Status
├─ Telegraph Routes Setup     ████████  ░░░░░░░░  None           🔄 In Progress
├─ Queue System & Worker      ░░░░░░░░  ████████  Routes         ⏳ Pending
├─ Permission System          ░░░░░░░░  ████████  Queue          ⏳ Pending
└─ Database Optimization      ░░░░░░░░  ████████  Permissions    ⏳ Pending
```

**جزئیات فاز 1:**
- **Telegraph Routes** (1-2 روز)
  - ثبت `routes/telegraph.php` در RouteServiceProvider
  - تنظیم webhook: `POST /api/telegram/webhook`
  - تست `route:list` و `getWebhookInfo`

- **Queue System** (2-3 روز)
  - ایجاد جداول queue: `queue:table && migrate`
  - راه‌اندازی Worker و Cron برای `schedule:run`
  - تست background jobs

- **Permission System** (3-4 روز)
  - Publish و migrate spatie/permission
  - ایجاد roles و permissions
  - حفاظت admin endpoints

- **Database Optimization** (1-2 روز)
  - اضافه کردن index روی `payments.ref`
  - بهینه‌سازی queries پرتکرار

---

### **فاز 2: Core Telegram Bot (هفته 3-5)**
```
Task                          Week 3    Week 4    Week 5    Dependencies    Status
├─ Menu System Enhancement    ████████  ░░░░░░░░  ░░░░░░░░  Phase 1        ⏳ Pending
├─ User Authentication        ░░░░░░░░  ████████  ░░░░░░░░  Menu System    ⏳ Pending
├─ Event Tracking Complete    ░░░░░░░░  ████████  ░░░░░░░░  User Auth      ⏳ Pending
└─ Callback Handlers          ░░░░░░░░  ░░░░░░░░  ████████  Event Track    ⏳ Pending
```

**جزئیات فاز 2:**
- **Menu System Enhancement** (4-5 روز)
  - منوی اصلی داینامیک از DB
  - پیاده‌سازی ماژول‌های negotiation, expert, help
  - تست کامل navigation flow

- **User Authentication Integration** (3-4 روز)
  - mapping امن بین Telegram users و REST API
  - حل مشکل `user_id = 1` در controllers
  - تست authentication flow

- **Event Tracking Complete** (2-3 روز)
  - تکمیل EventBus برای کاربران Telegram
  - اضافه کردن events مفقود: `HelpOpen`, `CallFromCard`, etc.
  - تست analytics pipeline

- **Callback Handlers** (3-4 روز)
  - پیاده‌سازی pagination برای opportunities
  - module handling برای callbacks
  - تست کامل callback flows

---

### **فاز 3: Business Logic (هفته 6-9)**
```
Task                          Week 6    Week 7    Week 8    Week 9    Dependencies    Status
├─ AI Integration Complete    ████████  ████████  ░░░░░░░░  ░░░░░░░░  Phase 2        ✅ Partial
├─ Payment Enhancement        ░░░░░░░░  ████████  ████████  ░░░░░░░░  AI Complete    ✅ Partial
├─ Ads Pipeline Complete      ░░░░░░░░  ░░░░░░░░  ████████  ████████  Payments       ✅ Partial
└─ External APIs & Saved Ads  ░░░░░░░░  ░░░░░░░░  ░░░░░░░░  ████████  Ads Pipeline   ⏳ Pending
```

**جزئیات فاز 3:**
- **AI Integration Complete** (5-7 روز)
  - تکمیل Memory: `chat_threads.previous_response_id`
  - VectorStore attach/detach & status (RAG)
  - بهینه‌سازی latency و error handling

- **Payment System Enhancement** (4-5 روز)
  - entitlement binding و subscription activation
  - reconcile scheduling و audit trails
  - admin visibility برای callbacks

- **Ads Pipeline Complete** (7-10 روز)
  - scheduling برای ads ingestion/scoring
  - pipeline برای mark opportunities reviewed/expired
  - تست کامل با MajidAPI

- **External APIs & Saved Ads** (3-4 روز)
  - Saved Ads external sources UX
  - Support tickets system
  - تست integration با external services

---

### **فاز 4: Admin & Analytics (هفته 10-12)**
```
Task                          Week 10   Week 11   Week 12   Dependencies    Status
├─ Filament Panel Complete    ████████  ████████  ░░░░░░░░  Phase 3        ⏳ Pending
├─ Analytics Dashboard        ░░░░░░░░  ████████  ████████  Filament       ⏳ Pending
├─ Push Campaigns             ░░░░░░░░  ░░░░░░░░  ████████  Analytics      ⏳ Pending
└─ Testing & Bug Fixes        ████████  ████████  ████████  All Phases     ⏳ Pending
```

**جزئیات فاز 4:**
- **Filament Panel Complete** (5-7 روز)
  - تکمیل همه Resources (Users/Plans/Payments/etc.)
  - KPI widgets و dashboard
  - Settings management (feature toggles & channels)

- **Analytics Dashboard** (4-5 روز)
  - گزارش روزانه و real-time metrics
  - CTR tracking و conversion funnels
  - Quality gates و monitoring

- **Push Campaigns** (3-4 روز)
  - سگمنت selection و campaign management
  - ارسال via Telegraph و click telemetry
  - A/B testing framework

- **Testing & Bug Fixes** (3-5 روز مداوم)
  - Unit tests برای critical paths
  - Integration tests برای end-to-end flows
  - Performance testing و optimization

---

## 🎯 Milestones و Acceptance Criteria

### **Milestone 1: Infrastructure Ready (End of Week 2)**
- ✅ `route:list` shows `/telegram/webhook`
- ✅ `getWebhookInfo` returns OK
- ✅ Worker/scheduler running
- ✅ No 404/401 on webhook
- ✅ Admin panel accessible with proper permissions

### **Milestone 2: Core Bot Functional (End of Week 5)**
- ✅ Onboarding completes successfully
- ✅ Main menu DB-driven
- ✅ All events recorded properly
- ✅ User authentication secure
- ✅ All callback handlers working

### **Milestone 3: Business Logic Complete (End of Week 9)**
- ✅ AI valuation working with memory
- ✅ Payment flow end-to-end
- ✅ Ads pipeline automated
- ✅ External integrations stable
- ✅ All modules functional

### **Milestone 4: Production Ready (End of Week 12)**
- ✅ Admin panel fully operational
- ✅ Analytics dashboard live
- ✅ Push campaigns working
- ✅ All tests passing
- ✅ Performance benchmarks met

---

## 📈 KPI Targets

### **Technical KPIs**
- AI Response Latency: ≤ 2.5s (P80)
- Payment Success Rate: ≥ 98%
- Webhook Uptime: ≥ 99.9%
- Database Query Time: ≤ 100ms (P95)

### **Business KPIs**
- CTR Opportunities: ≥ 25%
- D1 User Activation: ≥ 40%
- Saved/Delivered Ratio: ≥ 10%
- User Retention (D7): ≥ 30%

---

## ⚠️ Critical Dependencies & Risks

### **High Risk Items**
1. **Telegraph Integration** - Blocker برای کل پروژه
2. **MajidAPI Stability** - External dependency
3. **OpenAI Rate Limits** - Cost و performance impact
4. **Payment Gateway** - Zarinpal integration issues

### **Mitigation Strategies**
- **Telegraph**: Fallback به manual webhook setup
- **MajidAPI**: Fixture data برای development
- **OpenAI**: Rate limiting و caching strategies
- **Payments**: Sandbox testing extensive

---

## 🔄 Weekly Review Points

### **Week 2 Review**
- Infrastructure stability check
- Performance baseline establishment
- Security audit completion

### **Week 5 Review**
- User experience testing
- Bot functionality validation
- Analytics data verification

### **Week 9 Review**
- Business logic validation
- Integration testing completion
- Performance optimization

### **Week 12 Review**
- Production readiness assessment
- Launch criteria verification
- Post-launch monitoring setup

---

## 📋 Resource Allocation

### **Development Team**
- **Backend Developer**: Full-time (Laravel/PHP)
- **DevOps Engineer**: Part-time (Infrastructure)
- **QA Tester**: Part-time (Testing)
- **Product Manager**: Part-time (Requirements)

### **External Dependencies**
- **Telegram API**: Rate limits monitoring
- **MajidAPI**: SLA agreement
- **OpenAI**: Usage monitoring
- **Zarinpal**: Integration support

---

*آخرین به‌روزرسانی: 2025-01-17*
*نسخه: 1.0*
*وضعیت: Active Development*