# GAPS_AND_ACTIONS

## Table of Contents
- Ordered Gaps (Severity)
- Actions (Owner, Effort, Dependencies, Test Note)
- Proposed patch (do not apply yet)

## Ordered Gaps (Updated 2025-09-21)
- **High**: Telegram menu modules (negotiation, expert/help/account/support) هنوز placeholder هستند؛ قیمت‌یار و آگهی‌های به‌قیمت اکنون فعال است ولی لاگ/آنالیتیکس برای کاربران تلگرام تکمیل نشده.
- **High**: HTTP controllers (Saved Ads, Payments, Support, Admin) rely on `user_id = 1`; no secure auth mapping between Telegram users and REST API.
- **High**: Admin-managed menu/config/push experiences missing; Filament resources are skeletons only.
- **High**: Analytics coverage incomplete (no PriceCheck from Telegram, no push metrics, no ChecklistRun/CallFromCard/etc.).
- **Medium**: Ads ingestion/scoring not scheduled; no pipeline to mark opportunities reviewed/expired automatically.
- **Medium**: Affordable Ads search filters very strict (7 days + city + score ≥ 0.6 + reviewed status) may return "no results" immediately after fresh scrape due to timing.
- **Low**: Affordable Ads "مشاهده آگهی‌های فعلی" limited to 10 items with no pagination.
- **Low**: Affordable Ads car search limited to predefined brands (206, ساینا, کوییک, تیبا, تیبا 2, 207, پراید) with no dynamic brand list.
- **Medium**: Growth plumbing (quotas, entitlements, addons, experiments, referrals, trials) unreached by runtime flows.
- **Medium**: Support tickets & Saved Ads external sources have no UX and rely on placeholder auth.
- **Medium**: Payments lacks entitlement binding, reconcile scheduling, and audit trails; callbacks succeed but have no admin visibility.
- **Low**: Docs (PRD-linked) drifted from implementation; acceptance sheet/tests still assume fully built product.

## Recently Resolved Issues (2025-09-21)
- ✅ **RESOLVED**: Telegraph document sending with captions - `Call to undefined method DefStudio\Telegraph\Telegraph::caption()` error
  - **Solution**: Changed `->caption($caption)` to `->withData('caption', $caption)` in `TelegramBot::sendDocument()` method
  - **Impact**: Legal contract files (`/قولنامه` command) now work correctly with proper captions
- ✅ **RESOLVED**: Contract files not found - Files were in `contracts/` but code looked in `storage/app/contracts/`
  - **Solution**: Copied all contract files to `storage/app/contracts/` directory
  - **Files Available**: `sample_contract.pdf`, `buy_contract_template.txt`, `sell_contract_template.txt`, `sample_contract.txt`
- ✅ **RESOLVED**: Legal disclaimer message inconsistency
  - **Solution**: Updated `LEGAL_DISCLAIMER` constant and unified all messages to use centralized constant
  - **Impact**: Professional, consistent legal messaging across all contract communications

## Actions
- **Telegram feature parity**
  - Owner: Backend
  - Effort: L
  - Goal: Implement valuation/negotiation/expert/legal/help/account/support flows, including message routing and module memory.
- **Auth bridge (Telegram ↔ HTTP)**
  - Owner: Backend
  - Effort: M
  - Goal: Map Telegram users to `users.id` for REST controllers; replace `optional($request->user())->id ?? 1` fallbacks; enforce auth on admin APIs.
- **Admin-configurable menu & content**
  - Owner: Backend
  - Effort: M
  - Goal: Wire `menu_items`, feature toggles, and push scheduling to Filament UI.
- **Ads ingestion scheduling + lifecycle**
  - Owner: Backend
  - Effort: M
  - Goal: Schedule MajidAPI jobs, promote opportunities to `reviewed`, expire stale entries, and record push telemetry.
- **Affordable Ads UX improvements**
  - Owner: Backend
  - Effort: S
  - Goal: Add pagination to "مشاهده آگهی‌های فعلی" (currently limited to 10 items), relax search filters for better user experience, and add dynamic car brand selection.
- **Payments hardening**
  - Owner: Backend
  - Effort: M
  - Goal: Bind payments to authenticated users, reconcile automatically, expose admin audit/logs, integrate entitlements.
- **Analytics coverage**
  - Owner: Backend
  - Effort: M
  - Goal: Emit remaining events (PriceCheck from Telegram, PushOpen/CallFromCard/etc.), persist chats for Telegram usage, and surface metrics in admin dashboards.
- **Support & Saved Ads HTTP surfaces**
  - Owner: Backend
  - Effort: M
  - Goal: Finalize ownership checks, external save payloads, notifications, and tie flows back to Telegram users.
- **Growth plumbing activation**
  - Owner: Backend
  - Effort: L
  - Goal: Integrate quotas/entitlements/addons/experiments/referrals/trials with actual product flows.
- **Doc alignment**
  - Owner: Backend
  - Effort: S
  - Goal: Keep PRD, Acceptance Sheet, Project Status, SUMMARY, TELEGRAM_UX in sync with implementation progress.

## Environment-specific Actions
- Host (cPanel):
  - Ensure PHP ext-intl enabled (Filament); Docroot points to `public/`.
  - Register cron for `schedule:run` and run `queue:work` via supervisor/daemon.
  - Set Telegram webhook to `/telegram/webhook` with secret token.
  - Owner: Backend
  - Effort: S
  - Deps: none
  - Test: ERD reflects plan_entitlements, user_quotas, addons, wallet, experiments, push, referrals, cancellations

## Proposed patch (do not apply yet)
```diff
// routes/api.php
- Route::get('/user/saved_ads', [SavedAdsController::class, 'index'])->middleware('feature.guard:deal_view');
+ Route::get('/user/saved_ads', [SavedAdsController::class, 'index'])->middleware('feature.guard:view_deals');

// app/Http/Controllers/PaymentsController.php (illustrative)
 // In verify():
 // - Look up by provided authority, fail if not found or already ok
 // - Bind to authenticated user (or mapped tg user)
 // - Emit UpgradeSuccess via EventBus
```
