# IMPLEMENTATION PLAN (Haji Bot)

## Order of build

1) ✅ DB & Migrations (all tables listed in PRD.md §Database)
2) ✅ Telegram (Telegraph) + /telegram/webhook
3) 🔄 Admin Panel (Filament): Users, Menu, Prompts, VectorStores, Payments
4) 🔄 Payments (Zarinpal): create → verify → activate subscription
5) ✅ AI Provider (OpenAI Responses + file_search + memory) with LlmProvider interface
6) 🔄 Ads Jobs (majidapi): Bama latest/search/details + Divar scraper profiles → normalize/dedup/score
7) 🔄 Opportunities workflow (draft→reviewed→scheduled→sent) + Push
8) Core features:
   - 🔄 Affordable Ads (-15% → fallback -10% → rule-based)
   - ✅ Valuation (JSON structured)
   - 🔄 Negotiation (scenario + guided Q&A)
   - 🔄 Expert Q&A + Inspection Checklist (buy/sell)
   - ✅ Legal Q&A
   - ✅ Contracts (2 fixed PDFs) - **FIXED: Document sending with captions now works**
   - 🔄 Quick Visit 3-min (buy/sell checklist)
   - 🔄 City Report, Help
9) 🔄 Vector Stores attach/detach in Admin
10) 🔄 Analytics + Feature Flags + Quotas + Rate-limit
11) ❌ Tests (webhook, jobs, payments, AI call)

## Recent Implementation Updates (2025-09-21)

### ✅ Telegraph Document Sending Resolution
**Status**: COMPLETED
- **Issue**: `Call to undefined method DefStudio\Telegraph\Telegraph::caption()` error
- **Solution**: Updated `TelegramBot::sendDocument()` method to use `->withData('caption', $caption)` instead of `->caption($caption)`
- **Impact**: Legal contract files (`/قولنامه` command) now work correctly with proper captions
- **Files Modified**: `app/Services/Messaging/TelegramBot.php` (line 493)

### ✅ Contract Files Path Resolution
**Status**: COMPLETED
- **Issue**: Contract files were in `contracts/` directory but code looked in `storage/app/contracts/`
- **Solution**: Copied all contract files to `storage/app/contracts/` directory
- **Files Available**:
  - `sample_contract.pdf` (744 bytes) - Main contract file
  - `buy_contract_template.txt` (968 bytes) - Buy contract template
  - `sell_contract_template.txt` (968 bytes) - Sell contract template
  - `sample_contract.txt` (1517 bytes) - Additional sample contract

### ✅ Legal Disclaimer Message Standardization
**Status**: COMPLETED
- **Issue**: Inconsistent legal disclaimer messages across contract delivery
- **Solution**: Updated `LEGAL_DISCLAIMER` constant and unified all messages
- **New Message**: "📋 این قولنامه توسط یک وکیل مجرب نوشته شده است. با پرینت گرفتن می‌توانید استفاده کنید."
- **Files Modified**: `app/Http/Controllers/TelegramWebhookController.php`

### 🎯 Next Priority Items
1. **Admin Panel Completion**: Finalize Filament resources for full admin control
2. **Payments Integration**: Complete Zarinpal integration with proper user binding
3. **Analytics Implementation**: Add comprehensive event tracking for Telegram interactions
4. **Ads Pipeline**: Complete MajidAPI integration and opportunity scoring
5. **Feature Module Completion**: Implement remaining placeholder modules (negotiation, expert, help, account, support)

## Acceptance snapshot

- CTR opportunities ≥ 25%, AI latency ≤ 2.5s (80%), payment success ≥ 98%
