# قابلیت بازدید ۳ دقیقه‌ای

## توضیحات
این قابلیت به کاربران کمک می‌کند تا در کمتر از ۳ دقیقه ریسک خرید یا فروش خودرو را ارزیابی کنند.

## ویژگی‌ها
- ۸-۱۰ سوال سریع و هدفمند
- محاسبه امتیاز ریسک (۰-۱۰۰)
- تعیین سطح ریسک (پایین/متوسط/بالا)
- ارائه توصیه‌های عملی
- پشتیبانی از دو نوع معامله (خرید/فروش)
- سیستم تعاملی سوال و جواب
- ردیابی پیشرفت بازدید

## API Endpoints

### شروع بازدید
```http
POST /api/inspection/start
Authorization: Bearer {token}
Content-Type: application/json

{
  "type": "buy|sell",
  "ad_id": 123
}
```

**Response:**
```json
{
  "inspection_id": 1,
  "questions": [...],
  "total_questions": 7
}
```

### پاسخ به سوال
```http
POST /api/inspection/{id}/answer
Authorization: Bearer {token}
Content-Type: application/json

{
  "answer": "عالی"
}
```

**Response:**
```json
{
  "inspection": {...},
  "is_complete": false,
  "next_question": {...},
  "progress": {
    "current": 1,
    "total": 7,
    "percentage": 14,
    "is_complete": false
  }
}
```

### مشاهده نتیجه
```http
GET /api/inspection/{id}
Authorization: Bearer {token}
```

**Response:**
```json
{
  "id": 1,
  "user_id": 1,
  "ad_id": 123,
  "inspection_type": "buy",
  "status": "completed",
  "risk_score": 85,
  "risk_level": "low",
  "recommendations": [...],
  "answers": {...},
  "completed_at": "2025-01-15T10:30:00Z"
}
```

### پیشرفت بازدید
```http
GET /api/inspection/{id}/progress
Authorization: Bearer {token}
```

### لغو بازدید
```http
POST /api/inspection/{id}/cancel
Authorization: Bearer {token}
```

## Database Schema

### جدول `inspections`
```sql
CREATE TABLE inspections (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    user_id BIGINT UNSIGNED NOT NULL,
    ad_id BIGINT UNSIGNED NULL,
    inspection_type ENUM('buy', 'sell') NOT NULL,
    status ENUM('in_progress', 'completed', 'cancelled') DEFAULT 'in_progress',
    risk_score INT NULL,
    risk_level ENUM('low', 'medium', 'high') NULL,
    recommendations JSON NULL,
    answers JSON NULL,
    current_question INT DEFAULT 0,
    completed_at TIMESTAMP NULL,
    created_at TIMESTAMP NULL,
    updated_at TIMESTAMP NULL,
    
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (ad_id) REFERENCES opportunities(id) ON DELETE SET NULL,
    
    INDEX idx_user_status (user_id, status),
    INDEX idx_type_status (inspection_type, status),
    INDEX idx_risk_level (risk_level)
);
```

## Telegram Bot Integration

### شروع بازدید
کاربر از منوی اصلی گزینه "بازدید ۳ دقیقه‌ای" را انتخاب می‌کند:

```
🔍 بازدید ۳ دقیقه‌ای

برای شروع بازدید سریع، نوع معامله را انتخاب کنید:

[🛒 چک‌لیست خرید] [💰 چک‌لیست فروش]
[🏠 بازگشت به منو اصلی]
```

### سوالات تعاملی
```
🔍 بازدید ۳ دقیقه‌ای - خرید خودرو

سوال ۱ از ۷: وضعیت ظاهری خودرو چطوره؟

[عالی] [خوب] [متوسط] [ضعیف]
[❌ لغو بازدید]
```

### نتیجه نهایی
```
✅ نتیجه بازدید ۳ دقیقه‌ای

امتیاز ریسک: 85/100
سطح ریسک: 🟢 پایین

توصیه‌ها:
• ✅ ریسک پایین: خودرو مناسب برای خرید
• 🎯 قیمت منصفانه است
• 📋 مدارک را بررسی کنید

---
برای شروع بازدید جدید، از منوی اصلی استفاده کنید.

[🏠 بازگشت به منوی اصلی]
```

## سوالات و امتیازدهی

### سوالات خرید (۷ سوال)
1. **وضعیت ظاهری** (وزن: ۱۵٪)
2. **موتور و سیستم‌های فنی** (وزن: ۲۰٪)
3. **تست رانندگی** (وزن: ۲۵٪)
4. **مدارک خودرو** (وزن: ۱۵٪)
5. **قیمت خودرو** (وزن: ۱۰٪)
6. **فروشنده** (وزن: ۱۰٪)
7. **سابقه تعمیرات** (وزن: ۵٪)

### سوالات فروش (۷ سوال)
1. **آماده‌سازی خودرو** (وزن: ۱۵٪)
2. **آماده‌سازی مدارک** (وزن: ۲۰٪)
3. **قیمت‌گذاری** (وزن: ۱۵٪)
4. **مذاکره** (وزن: ۱۰٪)
5. **نکات امنیتی** (وزن: ۱۵٪)
6. **زمان‌بندی فروش** (وزن: ۱۰٪)
7. **بررسی خریداران** (وزن: ۱۵٪)

### محاسبه ریسک
- **امتیاز ۸۰-۱۰۰**: ریسک پایین 🟢
- **امتیاز ۶۰-۷۹**: ریسک متوسط 🟡
- **امتیاز ۰-۵۹**: ریسک بالا 🔴

## تست‌ها

### Unit Tests
- `InspectionTest`: تست‌های اصلی service
- `InspectionApiTest`: تست‌های API endpoints

### اجرای تست‌ها
```bash
# تمام تست‌های inspection
php artisan test --filter=Inspection

# تست‌های API
php artisan test --filter=InspectionApi

# تست‌های service
php artisan test --filter=InspectionTest
```

## استفاده در کد

### شروع بازدید
```php
use App\Services\Inspection\InspectionService;

$inspectionService = app(InspectionService::class);
$inspection = $inspectionService->startInspection($user, 'buy');
```

### پاسخ به سوال
```php
$updatedInspection = $inspectionService->answerQuestion($inspection, 'عالی');
```

### تکمیل بازدید
```php
if ($inspectionService->isInspectionComplete($inspection)) {
    $completedInspection = $inspectionService->completeInspection($inspection);
}
```

### دریافت پیشرفت
```php
$progress = $inspectionService->getProgress($inspection);
// ['current' => 3, 'total' => 7, 'percentage' => 43, 'is_complete' => false]
```

## نکات مهم

1. **امنیت**: هر کاربر فقط می‌تواند بازدیدهای خود را مشاهده و ویرایش کند
2. **اعتبارسنجی**: تمام ورودی‌ها اعتبارسنجی می‌شوند
3. **خطاها**: خطاها به صورت user-friendly نمایش داده می‌شوند
4. **لاگ‌گیری**: تمام عملیات لاگ می‌شوند
5. **Performance**: سوالات و پاسخ‌ها در memory cache می‌شوند

## آینده

- اضافه کردن سوالات بیشتر
- پشتیبانی از زبان‌های دیگر
- تحلیل‌های پیشرفته‌تر
- گزارش‌های آماری
- ادغام با سیستم‌های خارجی
