# OPEN_QUESTIONS

## Table of Contents
- Identity & Auth
- Product & Feature Design
- Payments & Growth
- Ops & Monitoring

## Identity & Auth
- Telegram identity mapping: Should we store `tg_id` only, or also username/phone? Any policy on updates and merges?
- Admin access model: Confirm use of `spatie/laravel-permission`, required roles/permissions matrix for admin endpoints and Filament.
- Rate limiting identity: For AI, should we key strictly by Telegram user (mapped to `users.id`), or fall back to IP in production too?
 - API auth for non-Telegram endpoints: Do we need token-based auth for `/api/*` beyond Telegram-sourced interactions?

## Product & Feature Design
- Affordable ads rules: Confirm thresholds and fallback rules when median samples < `median_min_samples` (config/ads.php). Any brand/model exceptions?
- Saved Ads scope: Is saving allowed only from pushes, or also from organic browse? Should duplicates across sources be merged by dedup rules?
- Support tickets: Is user–admin messaging bi-directional within Telegram threads, or ticket-only via API?
- Legal Q&A disclaimer source: Managed via admin panel text or static config? Localization needs?
- City normalization: Is the provided cities/aliases list sufficient? Any external updates expected or manual maintenance only?
 - Help and Account flows: Final content and expected deep-links?

## Payments & Growth
- Payments: Confirm gateway (Zarinpal) and sandbox details. Idempotency key — use `authority` or gateway `ref`? Timeout/verify retry policy?
- Plans & pricing: Final set of plan keys and entitlements (free, member, pro, elite) — seeders create placeholders; confirm official pricing/benefits.
- Add-ons catalog: Which add-ons launch v1? How should UI expose them? Entitlement JSON schemas standardization?
- Referral rewards: Reward amounts and funding source (wallet_ledger) for `paid` events — caps per day/week/month beyond daily cap?
- Cancellations: Available rescue offers (freeze, discount); any time limit; impact on subscription status transitions?
 - Experiments: Are PUSH_HOUR/UPSELL_MESSAGE active with assignment at first contact, or gated by role/city?

## Ops & Monitoring
- Scheduling: Target frequencies for PushScheduler, ScoreOpportunities, GrowthDaily, PaymentsReconcile. Any blackout windows?
- Alerts & dashboards: Which channels (email/Telegram) and thresholds (latency, payment success, ingestion errors) for incident response?
- Data retention: Retention policy for chats, events, push logs, ads_raw; archival/TTL strategy and storage constraints.
 - Incident runbooks: Who on-call, and what is the rollback/feature-flagging procedure?
