سلام همکار 👋

کاملاً متوجه‌ام. طبق طراحی نهایی «حاجی» که با هم قفلش کردیم، این **PRD جامع** را می‌دهم؛ منبع واحد برای توسعه با Cursor و اجرای مستقیم در Laravel + MySQL روی cPanel. در هرجا که بین این پرامپت و طراحی قبلی اختلافی بود، **مرجع، طراحی محصول نهایی** است.

(نکته: موارد مربوط به «Retention/Privacy/ToU» عمداً وارد نشده‌اند چون پیش‌تر گفتی فعلاً خارج از سند باشند.)

---

# PRD — ربات تلگرام «حاجی»

## 1) معرفی و ارزش پیشنهادی (Core Value Proposition)

«حاجی» نمایشگاه دیجیتال + مشاور همیشه‌آنلاین برای کاسب/نمایشگاه‌دار/دلال خودرو در ایران است. هستهٔ ارزش:

* **فرصت‌های روز** : شناسایی و ارائهٔ فرصت‌های معاملاتی «به‌قیمت» و قابل اقدام.
* **قیمت‌یارِ قابل‌دفاع** : بازهٔ منصفانه + لنگر (Anchor) + اطمینان + سه دلیل کوتاه، با RAG.
* **تمرین مذاکرهٔ واقعی** : سناریوهای آماده + Q&A هدایت‌گر با حافظهٔ مکالمه.
* **پاسخ حقوقی/کارشناسی در لحظه** : پاسخ‌های کوتاه، دقیق، عمل‌محور؛ چک‌لیست «کارشناسی‌یار».

مخاطب: کاسبان ایرانی، نمایشگاه‌داران، دلالان (تازه‌کار تا حرفه‌ای).

لحن: رک، کوتاه، عمل‌محور.

اصل تجربه: کم‌اصطکاک، یک‌لمسی، بدون واژه‌های پیچیده.

---

## 2) پشتهٔ فناوری (Exact Tech Stack)

* **Backend** : Laravel 10 (PHP 8.2)، MySQL (cPanel)، Queue (Database driver)، Cron (schedule:run).
* **Telegram Bot** : `defstudio/telegraph`
* **AI** :
* Provider فعلی:  **OpenAI Responses API** .
* Retrieval: **file_search** با **Vector Store** (RAG داخلی؛ چانک/امبد/جستجو خودکار).
* مدل پیش‌فرض: **gpt-4o-mini** (از پنل به‌ازای هر ماژول قابل تغییر).
* حافظهٔ مکالمه: `store: true` + استفاده از `previous_response_id` به‌ازای Thread ماژول.
* Vector Stores:
  * **VS_MAIN** : دانش «هوش خودرو» و همهٔ حوزه‌های اصلی (قیمت‌گذاری/مذاکره/حقوق/کارشناسی/…).
  * **VS_IG** : دانش تخصصی اینستاگرام (سناریو، کپشن، هشتگ).
* **پرداخت** : زرین‌پال (`shetabit/payment`).
* **آگهی‌ها** : **majidapi** (باما: latest/search/details/… | دیوار: tools/scraper).
* **PDF ثابت** : `barryvdh/laravel-dompdf` (برای فاکتور/در صورت نیاز؛ قولنامه این نسخه فایل ثابت سرو می‌شود).
* **HTTP Client** : `guzzlehttp/guzzle`.
* **Admin Panel** : `filament/filament` + `spatie/laravel-permission`.
* **Logs/Monitoring** : لاگ Laravel + گزارش‌های روزانه (ایمیل/تلگرام ادمین).
* **قابلیت افزودن Provider دوم (OpenRouter)** : با لایهٔ انتزاع `LlmProvider` آماده.

### وابستگی‌ها (Packages/Libraries/APIs)

* Laravel 10، PHP 8.2، MySQL 8
* `guzzlehttp/guzzle`
* `defstudio/telegraph` یا `irazasyed/telegram-bot-sdk`
* `filament/filament`
* `spatie/laravel-permission`
* `shetabit/payment`
* `barryvdh/laravel-dompdf`
* (اختیاری) `fruitcake/laravel-cors`، `laravel/sanctum` در صورت نیاز
* **APIs** :
* OpenAI Responses + Vector Stores
* majidapi (باما/دیوار)
* زرین‌پال

---

## 3) اهداف و سنجه‌ها (Goals & Metrics)

* **North Star** : تعداد فرصت‌های «به‌قیمت» دیده‌شده که منجر به اقدام شد / کاربر / هفته.
* **Activation D1** : ≥ 60% (در روز اول کاربر حداقل یکی از: قیمت‌یار / تمرین مذاکره / چک‌لیست را اجرا کند).
* **CTR «فرصت‌های امروز»** : ≥ 25%.
* **ذخیرهٔ آگهی** : ≥ 10%.
* **Latency پاسخ AI** : ≤ 2.5 ثانیه در 80% موارد.
* **نرخ موفقیت پرداخت** : ≥ 98%.

---

## 4) قابلیت‌ها در محدوده (In Scope)

* 🔎 **فرصت‌های امروز** (Push انتخابی با ادیت انسانی)
* 💸 **آگهی‌های به قیمت** (فهرست لحظه‌ای شهر کاربر + لینک مستقیم)
* 💰 **قیمت‌یار** (Structured Output + RAG)
* 🗣️ **تمرین مذاکره و فروش** (سناریو + Q&A هدایت‌گر با حافظه)
* 🛠️ **سؤالات کارشناسی** (+ **کارشناسی‌یار** چک‌لیستی خرید/فروش)
* ⚖️ **سؤال حقوقی** (کوتاه، بولت‌وار، دیسکلیمر ثابت)
* 🧾 **قولنامه آماده** (دو فایل ثابت: خرید / فروش برای چاپ)
* 🔧 **بازدید ۳ دقیقه‌ای** (چک‌لیست حین معامله: خرید/فروش → ریسک‌مپ)
* 🏙️ **گزارش شهر من** (هفتگی)
* ✍️ **ایده/کپشن/هشتگ (اینستاگرام)** (RAG روی VS_IG)
* 📘 **راهنما** (توضیح کامل قابلیت‌ها و «شروع سریع»)
* 👤 **حساب من** (نقش/شهر/فرکانس/اشتراک)
* 💳 **پرداخت/اشتراک** (زرین‌پال، یک پلن؛ کوتا per-module)
* 🆘 **پشتیبانی** (تیکت داخلی)

### خارج از محدودهٔ این نسخه (Out of Scope — پیشنهاد برای بعد)

* شخصی‌سازی پیشرفته بر اساس رفتار طولانی‌مدت و مدل امتیازدهی ML.
* پنل چنداپراتوری با نقش‌های تیمی پیچیده.
* تولید محتوای تصویری/ویدئویی برای اینستاگرام.
* اپ موبایل مستقل (غیر از تلگرام).
* سیستم نوتیفیکیشن پوش چندکاناله غیر از تلگرام.
* تحلیل‌های بازار با منابع بیرونی پیچیده (BI داشبورد گسترده).

---

## 5) معماری و طراحی فنی

### 5.1 لایه‌ها

* **Bot App (Laravel)** : منطق دکمه‌ها، جریان‌ها، ادغام‌ها، صف‌ها، پنل ادمین، پرداخت.
* **AI Provider Layer** :
* اینترفیس:
  ```php
  interface LlmProvider {
    public function respond(LlmRequest $req): LlmResponse;
  }
  ```
* `OpenAiProvider`: فراخوان Responses + `tool_resources.file_search` + `store:true` + `previous_response_id`.
* `OpenRouterProvider`: بعداً با همین اینترفیس اضافه می‌شود.
* **RAG** :
* Vector Store داخلی OpenAI:
  * **VS_MAIN** : همهٔ چت‌بات‌ها (جز IG) به آن وصل‌اند.
  * **VS_IG** : مخصوص ماژول اینستاگرام.
* Attach/Detach فایل‌های TXT موجود در OpenAI Storage از پنل.
* هیچ citation به کاربر نمایش داده نمی‌شود.
* **Jobs/Workers** :
* جمع‌آوری آگهی‌ها از majidapi (باما latest/search/details، دیوار scraper).
* نرمال‌سازی، Dedup، Enrichment، امتیازدهی «به‌قیمت».
* Push کارت‌های «فرصت‌های امروز» و «آگهی ویژه».
* **Queue & Cron** : Database queue + `php artisan schedule:run` هر دقیقه.

### 5.2 الگوی حافظهٔ مکالمه

* جدول `chat_threads`: به ازای هر کاربر+ماژول یک Thread با `last_response_id`.
* در هر کال AI:
  * اگر Thread موجود: `previous_response_id = last_response_id`.
  * همیشه: `store: true` تا پاسخ در سمت OpenAI ذخیره و به‌صورت stateful ادامه یابد.
* جدول `chats`: لاگ پیام/پاسخ، tokens، latency.

### 5.3 یکپارچه‌سازی آگهی‌ها (majidapi)

* باما:
  * `latest?page=N`، `search?s=...&page=N`، `details&code=...`، `carPrice&brand=...`.
* دیوار:
  * `tools/scraper?url=...&className=...&id=...` (پروفایل‌های قابل‌تنظیم در پنل).
* Jobها:
  * `BamaPullLatestJob`، `BamaSearchJob`، `BamaDetailsJob`، `DivarScrapeJob`.
* نرمال‌سازی به اسکیمای داخلی + Dedup + امتیاز «به‌قیمت» + دلایل کوتاه.
* **Featured Ads** : ایجاد دستی آگهی ویژه از پنل و Push به سگمنت‌ها.

---

## 6) پایگاه‌داده (Complete Back-end Database Setup)

### 6.1 جداول کاربر/اشتراک/پرداخت

* `users`
  * `id`، `tg_id`، `role` (dealer|showroom|newbie)؛ `city`؛ `plan`؛ `notif_level` (low|normal|high)؛ timestamps
* `subscriptions`
  * `id`، `user_id`، `plan`، `starts_at`، `ends_at`، `status` (active|expired|canceled)
* `payments`
  * `id`، `user_id`، `gateway` (zarinpal)؛ `ref`؛ `amount`؛ `status` (pending|ok|failed)؛ `payload_json`؛ `created_at`

### 6.2 منو/پرامپت/مدل/RAG

* `menu_items`
  * `id`، `key`، `title`، `emoji`، `enabled`، `ord`، `visible_roles` (json)
* `prompt_configs`
  * `id`، `module`، `model` (پیش‌فرض gpt-4o-mini)؛ `temperature`، `top_p`، `enable_file_search` (bool)؛ timestamps
* `vector_stores`
  * `id`، `name` (VS_MAIN/VS_IG)، `openai_vector_store_id`، `is_active`
* `vector_files`
  * `id`، `vector_store_id`، `openai_file_id`، `tag` (valuation|legal|inspection|negotiation|…)، `status`

### 6.3 آگهی‌ها/فرصت‌ها/ویژه

* `ads_raw`
  * `id`، `source` (bama|divar)؛ `payload_json` (raw)؛ `fetched_at`
* `opportunities`
  * `id`، `source`، `code`، `brand`، `model`، `trim`، `year`، `km`، `city`، `price`، `body_status`، `link`، `contact_ref`،

    `dedup_key`، `score`، `reasons_json` (["کم‌کار","سال 1400"])، `status` (draft|reviewed|scheduled|sent|archived)، `ts_posted`، `pushed_at`، timestamps
* `featured_ads`
  * `id`، `title`، `description`، `price`، `city`، `link`، `target_roles`، `target_cities`، `scheduled_at`، `pushed_at`، `status`

### 6.4 محتوا/چک‌لیست/گزارش

* `legal_files`
  * `id`، `type` (buy|sell)؛ `file_path`؛ `updated_at`  (دو فایل ثابت قولنامه)
* `checklists`
  * `id`، `name`، `type` (inspection_buy|inspection_sell)؛ `questions_json` (آرایهٔ سؤال/راهنمای کوتاه)؛ `updated_at`
* `city_reports`
  * `id`، `city`، `week_no`، `summary_json`؛ `created_at`

### 6.5 چت/حافظه/رویداد

* `chat_threads`
  * `id`، `user_id`، `module`، `last_response_id`، `expires_at`، timestamps
* `chats`
  * `id`، `user_id`، `module`، `role` (user|assistant)؛ `text`؛ `response_id`؛ `token_in`، `token_out`، `latency_ms`، timestamps
* `events`
  * `id`، `user_id`، `type` (open_digest|opportunity_view|valuation_done|…)؛ `payload_json`؛ `created_at`

---

## 7) جریان‌های کامل کاربر (Complete User Flows)

### 7.1 `/start` و Onboarding

* کاربر: `/start`
* ربات: خوش‌آمد + پرسش نقش (نمایشگاه‌دار/دلال/تازه‌کار) → دکمه‌ها
* کاربر: انتخاب نقش → پرسش شهر/استان (با جستجو) → دکمه‌ها
* کاربر: انتخاب شهر → پرسش بودجه (سه بازه) → دکمه‌ها
* کاربر: انتخاب بودجه → پرسش فرکانس پیام (کم/معمولی/زیاد) → دکمه‌ها
* کاربر: انتخاب → پیام پایانی + نمایش **منوی اصلی**
* ذخیرهٔ انتخاب‌ها در `users`

### 7.2 🔎 فرصت‌های امروز (Push)

* ادمین در پنل، فرصت‌ها را **review** و **schedule/push** می‌کند.
* ربات برای کاربران هدف (نقش/شهر/فرکانس)، کارت‌ها را ارسال می‌کند.
* کارت شامل: عنوان، قیمت، سال/کارکرد، شهر، ۲ دلیل، دکمه‌ها:
  * **💰 قیمت‌یار** → پرش به جریان 7.4
  * **🗣️ تمرین مذاکره** → پرش به 7.5
  * **🔧 بازدید ۳ دقیقه‌ای** → پرش به 7.8
  * **⭐ ذخیره** → افزودن به لیست ذخیره

### 7.3 💸 آگهی‌های به قیمت (دکمهٔ مستقل)

* کاربر: دکمه را می‌زند.
* ربات: بر اساس شهر کاربر، 7–10 آگهی «معقول» را صفحه‌بندی می‌فرستد:
  * خلاصهٔ آگهی، قیمت، سال/کارکرد، ۲ دلیل کوتاه، **لینک مستقیم** به منبع (دیوار/باما)، دکمهٔ **⭐ ذخیره**
* دکمهٔ **Next/Prev** برای مرور دستهٔ بعدی.

### 7.4 💰 قیمت‌یار

* ربات: اطلاعات لازم را می‌پرسد (برند/مدل، سال، کارکرد، شهر، وضعیت بدنه/رنگ).
* کاربر: پاسخ‌ها را می‌دهد.
* ربات: کال Responses (RAG روی VS_MAIN) با  **structured JSON** ؛ خروجی:
  * بازهٔ min–max، Anchor، Confidence، ۳ دلیل کوتاه.
* ربات: پیام متنی کوتاه (بدون CTA تماس) با بازه، لنگر، اطمینان، دلایل؛ دکمهٔ «تحلیل قیمت» برای گزارش تکمیلی + دکمه‌های ماژول داخلی («🗣️ تمرین مذاکره»، «🔧 بازدید ۳ دقیقه‌ای»).

### 7.5 🗣️ تمرین مذاکره و فروش

* ربات: دو حالت را پیشنهاد می‌کند:
  * **سناریو آماده** : ۳ شروع (مودب/قاطع/حقوقی) + پاسخ به ۳ اعتراض.
  * **تمرین واقعی (Q&A)** : «وضعیت واقعی را بگو.»
* کاربر: وضعیت را شرح می‌دهد.
* ربات: سؤال‌های هدایت‌گر، دیالوگ پیشنهادی کوتاه،  **پلن اقدام ۳مرحله‌ای** ؛ ادامهٔ گفتگو روی  **Thread negotiation** .

### 7.6 🛠️ سؤالات کارشناسی

* کاربر: سؤال فنی/کارشناسی را مطرح می‌کند یا می‌زند «کارشناسی‌یار».
* ربات (Q&A): پاسخ بولتی، کوتاه، عمل‌محور (RAG روی VS_MAIN).
* ربات (کارشناسی‌یار): «خرید» یا «فروش»؟ → چک‌لیست مرحله‌به‌مرحله → **ریسک‌مپ** + «قدم بعدی».

### 7.7 ⚖️ سؤال حقوقی

* کاربر: سؤال کوتاه می‌پرسد.
* ربات: پاسخ بولت‌وار + هشدارهای مهم + دیسکلیمر کوتاه؛ RAG روی VS_MAIN.

### 7.8 🔧 بازدید ۳ دقیقه‌ای

* کاربر: «برای خرید» یا «برای فروش».
* ربات: 8–10 سؤال سریع → **ریسک‌مپ** + توصیهٔ اقدام.

### 7.9 🧾 قولنامهٔ آماده

* کاربر: «قولنامه خرید» یا «قولنامه فروش».
* ربات: فایل **ثابت** مربوطه را ارسال می‌کند (قابل چاپ).

### 7.10 🏙️ گزارش شهر من

* ربات: سه نکتهٔ مهم هفته، سه مدل پرمعامله، توصیهٔ کوتاه؛ CTA: «قیمت‌یار همین مدل».

### 7.11 ✍️ ایده/کپشن/هشتگ (اینستاگرام)

* ربات: موضوع/زاویهٔ محتوا را بپرسد.
* کاربر: وارد می‌کند.
* ربات: RAG روی **VS_IG** → خروجی: سناریو + ۲–۳ کپشن کوتاه + ۱۰ هشتگ.

### 7.12 📘 راهنما

* ربات: کارت‌های آموزشی کوتاه دربارهٔ هر دکمه + «نمونه ببین» + لینک به «پرداخت/اشتراک».

### 7.13 👤 حساب من

* نمایش: نقش، شهر، فرکانس پیام، وضعیت اشتراک/انقضا، مصرف ماژول‌ها (کوتا).
* دکمه‌ها: تغییر شهر/فرکانس، مدیریت اشتراک.

### 7.14 💳 پرداخت/اشتراک

* کاربر: انتخاب پلن (فعلاً یک پلن با مدت متغیر).
* ربات: فاکتور → درگاه زرین‌پال → بازگشت → `/payments/verify` → فعال‌سازی.
* خطای verify: پیام راهنما + لینک تلاش مجدد + reconcile job.

### 7.15 🆘 پشتیبانی

* کاربر: عنوان/متن تیکت.
* ربات: ثبت در `tickets` (اگر نیاز شد) یا پیام به ادمین؛ پاسخ در چت.

---

## 8) رفتار مورد انتظار (Functional Requirements)

### عمومی

* تمام دکمه‌ها از پنل قابل اضافه/حذف/ویرایش عنوان/ایموجی و ترتیب هستند.
* همهٔ ماژول‌ها RAG دارند (VS_MAIN)، جز اینستاگرام (VS_IG).
* مدل به‌ازای هر ماژول از پنل قابل انتخاب است (پیش‌فرض gpt-4o-mini).
* حافظهٔ ماژول‌محور: در هر ماژول Thread جدا با `store:true` + `previous_response_id`.

### 🔎 فرصت‌های امروز

* Jobهای جمع‌آوری از majidapi → Normalize/Dedup/Score/Reasons.
* ادمین review → schedule/push برای نقش/شهر/فرکانس.
* کارت شامل لینک مستقیم منبع (دیوار/باما) و دکمه‌های اقدام.

### 💸 آگهی‌های به قیمت

* معیار «معقول» قابل‌تنظیم در پنل (انحراف از میانه شهر یا قواعد fallback).
* لیست 7–10 تایی + صفحه‌بندی + لینک مستقیم + ذخیره.

### 💰 قیمت‌یار

* ورودی‌های کاربر جمع‌آوری شود؛ خروجی **JSON ساختاری** با `min/max/anchor/confidence/reasons[3]`.
* نمایش کارت خلاصه + CTAهای بعدی.
* خطا/ابهام: بازهٔ وسیع + پیام روشن.

### 🗣️ تمرین مذاکره و فروش

* سناریو آماده + تمرین Q&A هدایت‌گر.
* پاسخ‌ها کوتاه و عملی؛ سؤال‌های هدایت‌گر تا رسیدن به پلن اقدام.

### 🛠️ سؤالات کارشناسی + کارشناسی‌یار

* Q&A: پاسخ بولتی (RAG).
* کارشناسی‌یار: چک‌لیست خرید/فروش → ریسک‌مپ + اقدام بعد.

### ⚖️ سؤال حقوقی

* پاسخ کوتاه + دیسکلیمر ثابت؛ در موارد پیچیده اشاره به ارجاع.

### 🧾 قولنامهٔ آماده

* ارسال **دو فایل ثابت** (خرید/فروش) که در پنل بارگذاری می‌شوند.

### 🔧 بازدید ۳ دقیقه‌ای

* دو مسیر خرید/فروش؛ 8–10 سؤال؛ خروجی ریسک‌مپ + CTA.

### 🏙️ گزارش شهر من

* تولید هفتگی؛ قابل ارسال خودکار (Cron) و بنابر نقش/شهر.

### ✍️ ایده/کپشن/هشتگ (اینستاگرام)

* ورودی موضوع؛ خروجی سناریو + ۲–۳ کپشن + ۱۰ هشتگ (VS_IG).

### 📘 راهنما

* کارت‌های آموزشی؛ «نمونه ببین» برای شروع سریع.

### 👤 حساب من

* نمایش/ویرایش تنظیمات کاربر؛ نمایش اشتراک و مصرف.

### 💳 پرداخت/اشتراک

* یک پلن؛ جریان صدور/درگاه/verify/فعال‌سازی؛ reconcile در خطا.

### 🆘 پشتیبانی

* ثبت و پیگیری تیکت/پیام؛ اعلان به ادمین.

---

## 9) الزامات غیرعملکردی (Non-Functional)

* **قابلیت اتکا** : Uptime هدف 99.9% (هاست پایدار + صف و Cron پایدار).
* **کارایی** : پاسخ AI ≤ 2.5s در 80%؛ Jobs ریزدانه و تکرارشونده.
* **مقیاس‌پذیری** : Rate-limit (۵ req/min/کاربر)، Quota per module، Queue مدیریت‌شده.
* **امنیت** : کلیدها در `.env`، وبهوک امن، اعتبارسنجی ورودی‌ها، ماسک دادهٔ حساس در لاگ‌ها.
* **مشاهده‌پذیری** : لاگ latency و خطاها؛ داشبورد KPI؛ گزارش روزانه.

---

## 10) پنل ادمین (Filament)

* **منوها** : عنوان/ایموجی/ترتیب/فعال‌بودن/نقش‌ها.
* **Prompts & Models** : System/User Template، انتخاب مدل، پارامترها، فعال/غیرفعال file_search، **Test Prompt** (sandbox).
* **Vector Stores** : ثبت VS_MAIN و VS_IG، Attach/Detach فایل‌های Storage، وضعیت پردازش، برچسب (tag) اسناد.
* **فرصت‌ها** : فلو انتشار (draft→reviewed→scheduled→sent)، دلایل/امتیاز، Push به سگمنت‌ها.
* **آگهی ویژه** : ساخت/ویرایش/زمان‌بندی/Push؛ گزارش عملکرد.
* **آگهی‌های به قیمت** : پارامترهای الگوریتم (threshold درصدی، حداقل داده، قواعد fallback).
* **قولنامه** : آپلود دو فایل ثابت خرید/فروش.
* **چک‌لیست‌ها** : مدیریت سؤال‌ها (inspection_buy/sell).
* **اشتراک/پرداخت** : مدیریت پلن/قیمت/کوتا، لاگ تراکنش‌ها، verify دستی/بازپرداخت.
* **کاربران** : نقش/شهر/فرکانس/اشتراک.
* **Feature Flags** : خاموش/روشن ماژول‌ها.
* **آنالیتیکس** : CTR فرصت، DAU/MAU، استفادهٔ ماژول‌ها، latency/توکن، نرخ خطا.

---

## 11) APIهای داخلی (نمونهٔ قراردادها)

### AI (LlmProvider)

* `POST /ai/respond`
  * ورودی: `{ model, store, previous_response_id, tool_resources.file_search.vector_store_ids, input[messages...], response_format? }`
  * خروجی: `{ text | json, response_id, token_in, token_out, latency_ms }`

### Ads

* `POST /admin/opportunities/push`
* `POST /admin/featured_ads/push`
* `POST /admin/scrape_profiles/test`

### Payments

* `POST /payments/create`
* `GET /payments/verify?authority=...`
* `POST /payments/reconcile`

---

## 12) الگوریتم «به‌قیمت» (قابل تنظیم)

* **روش A (دادهٔ کافی)** :
* محاسبهٔ «میانهٔ شهر» برای `(brand, model, city)` از آخرین N آگهی معتبر.
* انتخاب آگهی‌هایی با انحراف منفی در بازهٔ قابل‌تنظیم (مثلاً -۱۰% تا -۲۵%).
* **روش B (fallback)** :
* قواعد: `year >= Ymin`، `km <= Kmax`، `body_status in {ok, minor}`، قیمت زیر X.
* **امتیازدهی** : ترکیبی از انحراف قیمت + سال/کارکرد/بدنه.
* **دلایل** : دو بولت کوتاه (مثلاً «کم‌کار»، «سال ۱۴۰۰»).
* **TTL** : >72h → قدیمی/بایگانی.

---

## 13) تست و پذیرش (Acceptance Criteria)

* فرصت‌های امروز: Pull→Normalize→Dedup→Review→Push؛ CTR هفتهٔ اول ≥ 25%.
* آگهی‌های به قیمت: ارسال 7–10 مورد معقول شهر + لینک مستقیم + صفحه‌بندی + ذخیره.
* آگهی ویژه: ساخت/Push؛ ثبت نرخ کلیک/ذخیره.
* قیمت‌یار: خروجی JSON معتبر (min/max/anchor/confidence/reasons)؛ ≤ 2.5s برای 80%.
* تمرین مذاکره: سناریو + Q&A هدایت‌گر؛ Thread پایدار؛ حداقل ۲ دور پرسش/پاسخ.
* سؤالات کارشناسی + کارشناسی‌یار: پاسخ بولتی + چک‌لیست خرید/فروش → ریسک‌مپ + CTA.
* سؤال حقوقی: پاسخ کوتاه + دیسکلیمر ثابت (متن از پنل).
* قولنامه: ارسال دو فایل ثابت (خرید/فروش).
* بازدید ۳ دقیقه‌ای: 8–10 سؤال + ریسک‌مپ + CTA.
* گزارش شهر من: تولید/ارسال هفتگی؛ CTA به قیمت‌یار.
* اینستاگرام: سناریو + ۲–۳ کپشن + ۱۰ هشتگ (VS_IG).
* پرداخت/اشتراک: verify موفق → فعال‌سازی؛ reconcile در خطا.
* پنل ادمین: انتخاب مدل per-module، Test Prompt، Attach/Detach فایل‌ها، Feature Flags.

---

## 14) برنامهٔ اجرا (چهارهفته‌ای، تیم یک‌نفره با Cursor)

* **هفته ۱** : اسکیمای DB + Seederها، تلگرام وبهوک، پنل پایه (Users/Menu/Prompts/VectorStores/Payments)، زرین‌پال (ایجاد/verify).
* **هفته ۲** : LlmProvider + OpenAiProvider (Responses+file_search+memory)، فرصت‌های امروز (Jobs+Review/Push)، آگهی‌های به‌قیمت، آگهی ویژه.
* **هفته ۳** : قیمت‌یار (JSON ساختاری)، تمرین مذاکره (سناریو+Q&A)، سؤالات کارشناسی+کارشناسی‌یار، سؤال حقوقی، بازدید ۳ دقیقه‌ای، گزارش شهر، قولنامه ثابت، راهنما.
* **هفته ۴** : مدیریت VS_MAIN/VS_IG در پنل (attach/detach+وضعیت)، استرس‌تست Jobs، Feature Flags، داشبورد KPI، تست‌های حداقلی و لانچ پایلوت ۵۰ نفره، سپس rollout.

---

## 15) نکات کیفیت و عملیات

* **Rate-Limit** : ۵ درخواست/دقیقه/کاربر (ماژول‌های AI).
* **Quota per Module** : قابل تنظیم برای کنترل هزینه توکن.
* **Timeout/Retry** : AI ۲۰s + ۱بار Retry؛ majidapi با backoff.
* **خطاهای کاربرپسند** : پیام‌های کوتاه + راه‌حل (افزودن جزئیات، تکرار).
* **کش نتایج پرتکرار** : برای پرسش‌های عمومی (TTL کوتاه).
* **Feature Flags** : خاموش/روشن ماژول هنگام Incident.
* **گزارش روزانه** : latency، error%، token usage، CTR فرصت، مصرف ماژول‌ها.

---

# پایان PRD (نسخه 1.0)

اگر این PRD را تأیید می‌کنی، بلافاصله نسخهٔ «چک‌لیست اجرایی با Acceptance قابل تیک‌زدن + روت‌ها + DTOهای درخواست/پاسخ + نمونه کدهای فراخوان Responses و Jobهای majidapi و verify زرین‌پال» را هم می‌دهم تا در Cursor مستقیم پیاده‌سازی را شروع کنی.

### دو سؤال کوتاه برای قفل نهایی:

1. برای **Telegram SDK** کدام را ترجیح می‌دهی: `defstudio/telegraph` یا `irazasyed/telegram-bot-sdk`؟
2. حد آستانهٔ اولیهٔ «به‌قیمت» را روی **-۱۵% نسبت به میانهٔ شهر** بگذاریم یا مقدار دیگری مدنظر داری؟
