# Quality Gates and Acceptance Criteria

Scope: pass/fail gates before coding completion, aligned to PRD §3, §13, §15.

## Performance Budgets

- AI latency: p80 ≤ 2.5s end-to-end for `/ai/respond` (measure server timer start→response) (PRD §3, §13).
- Payment success rate ≥ 98% over rolling 7 days (PRD §3; Implementation snapshot).
 - CTR for “Opportunities Today” ≥ 25% (week‑1 pilot).
   - Definition: numerator = any CTA click on an opportunity card; denominator = delivered messages (not attempted); window = week‑1.
 - Saved ads ≥ 10% (week‑1 pilot).
   - Definition: numerator = count of saves persisted in `saved_ads`; denominator = delivered messages (not attempted); window = week‑1.

## Data Contracts (must validate at boundaries)

- Valuation JSON schema (PRD §7.4):
  - `{ min:number, max:number, anchor:number, confidence:"low|medium|high", reasons:string[3] }`.
- AI Respond response envelope: `{ text?:string, json?:object, response_id:string, token_in:int, token_out:int, latency_ms:int }`.
- Payments verify: `{ status:"ok|failed", payment_id:int, ref:string|null, subscription?:{status:string} }`.
- Opportunities entity: `dedup_key` unique, `reasons_json` is non-empty array ≤ 3.
- Vector store IDs: valid UUID-like strings; `enable_file_search` honored per module.

## Feature Acceptance (per PRD §13)

- Opportunities pipeline: Pull→Normalize→Dedup→Score→Review→Push; TTL >72h archived; record push stats.
- Affordable Ads: returns 7–10 items for user city; −15% vs city median; fallback −10%; then rules; includes direct links; supports paging; ⭐ save action recorded in `saved_ads`.
- Valuation: Collect required inputs; produce valid JSON schema; UI renders summary text + internal module buttons (بدون CTA تماس/خرید)؛ ambiguity widens range and sets `confidence` appropriately.
- Negotiation: Provides scenario starters + guided Q&A; persists thread across at least 2 turns.
- Expert Q&A + Inspection: Bullet answers; checklist buy/sell leads to risk map + next step.
- Legal Q&A: Short bullets + admin-provided disclaimer included.
- Contracts: Sends two fixed files (buy/sell) from storage.
- Quick Visit 3-min: 8–10 questions then risk map + CTA.
- City Report: Weekly generation and segmented push.
- Instagram: Scenario + 2–3 captions + 10 hashtags; uses VS_IG.
- Payments/Subscription: Successful verify activates subscription; reconcile covers failures.
- Admin Panel: model per-module; Test Prompt; attach/detach vector files; feature flags.

## UX & Copywriting Gates
- No placeholder texts (مثل «در حال توسعه است») در مسیرهای اصلی (Start, Menu, Valuation, Payments, Saved Ads, Support).
- هر پیام حداکثر 4–6 خط + CTA واضح؛ دکمه‌ها 2–4، متن کوتاه و گویا. (پیام‌های قیمت‌یار و تحلیل قیمت استثناء هستند؛ صرفاً اطلاعات تحلیلی می‌دهند.)
- خطاها راه‌حل ارائه می‌کنند (چه کار کند؟)؛ کاربر هرگز نباید گیج بماند.

## Anti-Stub Policy
- تحویل فیچر بدون UX/پیام کامل «مجاز نیست». اگر ماژولی آماده نیست، در منو پنهان یا با راهنمای مشخص و لینک اقدام جایگزین ارائه شود.

## Reliability & Ops Gates

- Rate limit: 5 req/min/user on AI routes; returns 429 with retry-after (PRD §15).
- Timeouts/Retry: AI 20s + 1 retry; majidapi backoff; payment verify idempotent (PRD §15).
- Observability: daily report includes latency p50/p80/p95, error%, token usage, CTR, module usage (PRD §2, §15).
- Fail-safe flags: feature flag to disable a module on incident (PRD §15).

## Pre-Launch Checklist

- Webhook security: secret token validated.
- DB indexes in place (ERD normalization checklist).
- Seeders for menu/prompts/checklists loaded.
- Test vector stores attached; file status monitored.
- Payment sandbox tested end-to-end; reconcile job scheduled.
 - Plans table populated and active; `/payments/create` uses DB `amount_irr` and `duration_days`.
 - Entitlements & Quotas seeded; FeatureGuard middleware applied on valuation/deal_view/instant_push.
 - Experiments seeded; PushSchedulerJob scheduled; push_logs writable and used for CTR calculations.
 - Events emitted via EventBus::track for Start, SelectCity, ViewDeal, SaveDeal, PriceCheck, UpgradeClick, UpgradeSuccess, PushOpen.

## OPEN QUESTIONS

- None pending from current decisions; future CTR window beyond week‑1 pilot to be defined at rollout.
