# Requirements Checklist (Traceable to PRD)

This checklist consolidates all functional and non‑functional requirements with PRD traceability. Ambiguities are tracked under OPEN QUESTIONS.

## Functional Requirements

- Onboarding flow: role → city → budget range → notif frequency → show main menu (PRD §7.1).
- Onboarding city search uses `cities` + `city_aliases`; users store `city_id` (Final Decision #6).
- Dynamic main menu from admin: add/remove/edit title/emoji/order/visibility (PRD §8 عمومی; Product Design §3, §7).
- Push “Opportunities Today” to segments with admin review/schedule (PRD §7.2, §8 فرصت‌های امروز).
- “Affordable Ads” listing 7–10 items for user city, with paging, direct source link, and save action (PRD §7.3, §8 آگهی‌های به قیمت).
- Saved Ads (⭐): persist user saves with uniqueness per user for opportunity or external ad; list and un-save routes (Final Decision #1).
- Valuation (“قیمت‌یار”) structured JSON output min/max/anchor/confidence/reasons[3]; render card + CTAs; handle ambiguity (PRD §7.4, §8 قیمت‌یار, §13 acceptance).
- Negotiation coaching: ready scenarios + guided Q&A with conversation memory per module/thread (PRD §7.5, §8 تمرین مذاکره, §2 Tech Stack memory notes).
- Expert Q&A and Inspection Assistant: bullet answers (RAG), buy/sell checklist → risk map + next step (PRD §7.6, §7.8, §8 سؤالات کارشناسی, بازدید ۳ دقیقه‌ای).
- Legal Q&A: short bullet answers with disclaimer from admin panel (PRD §7.7, §8 سؤال حقوقی).
- Contracts: serve two fixed files (buy/sell) configurable via admin (PRD §7.9, §8 قولنامه آماده).
- City weekly report push with CTA; role/city targeted (PRD §7.10, §8 گزارش شهر من).
- Instagram ideas: scenario + 2–3 captions + 10 hashtags using VS_IG (PRD §7.11, §8 اینستاگرام, Product Design §6.8).
- Help screens with deep-links and editable content (PRD §7.12; Product Design §6.9, §7).
- My Account: show role/city/frequency/subscription; allow changing city/frequency; manage subscription (PRD §7.13; Product Design §7 Users/Subscription).
- Payments and subscription: create invoice → Zarinpal gateway → verify callback → activate subscription; reconcile job on errors (PRD §7.14, §15, §13 acceptance; Implementation Plan §4). `POST /payments/create` takes `{ plan }` only; amount/duration sourced from DB plans (IRR) (Final Decision #3).
- Support: user ticket or admin message pipeline; respond in chat (PRD §7.15).
- Support Tickets (v1): create/list user tickets and admin reply route (Final Decision #2).
- Admin features: model per-module selection, Test Prompt sandbox, attach/detach vector files, feature flags, quotas, rate-limit (PRD §2, §8 عمومی, §15; Product Design §7; Implementation Plan §9–10).
- Growth plumbing (Phase 2A): Entitlements & Quotas (plan_entitlements, user_quotas); Add-ons (addons, user_addons with entitlements_json); Trial & Wallet (trials, wallet_ledger); Experiments & Push (experiments, experiment_assignments, push_campaigns, push_logs + /simulate/click); Events tracking (EventBus::track); Referral (referral_links, referral_events); Cancellations.
- Ads ingestion: majidapi bama (latest/search/details) + divar scraper profiles; normalize, dedup, score, reason bullets; TTL/archive >72h (PRD §5، §11 Services/Jobs, §12 algorithm, §15 TTL, Product Design §5, §7, §8 Ads). Median-by-city uses normalized `city_id` (Final Decision #6).
- Opportunities workflow: draft → reviewed → scheduled → sent; push to target roles/cities/frequencies; record CTR/click/save (PRD §7.2, §8 فرصت‌های امروز, §13 acceptance; Implementation Plan §7).

## Non‑Functional Requirements

- Tech stack: Laravel 10, PHP 8.2, MySQL 8, Database Queue, Cron schedule:run (PRD §2; ARCHITECTURE.md).
- Telegram SDK: defstudio/telegraph (final) (PRD §2; ARCHITECTURE.md; Final Decision #4).
- AI Provider: OpenAI Responses API with file_search; default model gpt‑4o‑mini configurable per module; conversation memory store:true with previous_response_id (PRD §2, §4.2; Product Design §4.2, §9).
- Vector Stores: VS_MAIN and VS_IG; attach/detach OpenAI storage files with status tracking (PRD §2 Vector Stores; Product Design §4, §7).
- Payment gateway: Zarinpal via shetabit/payment (PRD §2, §7.14; ARCHITECTURE.md).
- Rate limit: 5 requests/min/user for AI modules (PRD §15).
- Quotas per module configurable (PRD §15).
- Timeouts/retries: AI 20s + 1 retry; majidapi with backoff; payments reconcile (PRD §15).
- Logging/monitoring: Laravel logs; daily reports (latency, error%, token usage, CTR, module usage) via email/Telegram (PRD §2 Logs/Monitoring, §15 گزارش روزانه).
- No citations in user output; concise, action‑oriented responses (Product Design §1, §9).
- Performance budget: AI response latency ≤ 2.5s at p80; payment success ≥ 98%; CTR ≥ 25% (delivered-based, week‑1); saved ≥ 10% (persisted in `saved_ads`) (PRD §3, §13; Final Decision #5).
- Admin RBAC via spatie/laravel‑permission (PRD §2; ARCHITECTURE.md).
- Fixed PDFs served from storage; no dynamic generation required initially (PRD §2 PDF, §7.9; Product Design §6.5).

## Data & Storage Requirements (Schema)

- Tables per PRD (users, subscriptions, payments, menu_items, prompt_configs, vector_stores, vector_files, ads_raw, opportunities, featured_ads, scrape_profiles, legal_files, checklists, city_reports, chat_threads, chats, events) with fields detailed in PRD §6.x and Product Design §8.
- Additional tables: `saved_ads` (uniqueness rules), `tickets` (v1 minimal), `plans` (amount_irr, duration_days, is_active), `cities`, `city_aliases` (Final Decision #1, #2, #3, #6).
- Keys/relations: FK subscriptions.user_id→users.id; payments.user_id→users.id; chat_threads.user_id→users.id; chats.user_id→users.id; events.user_id→users.id; vector_files.vector_store_id→vector_stores.id; users.city_id→cities.id; opportunities.city_id→cities.id; saved_ads.user_id→users.id; tickets.user_id→users.id; payments.plan_id→plans.id (Final Decision #6).
- Uniques: users.tg_id, opportunities.dedup_key; vector_stores.openai_vector_store_id; vector_files.openai_file_id (PRD §6; Product Design §8).
- Uniques (added): saved_ads per-user uniqueness (user_id+opportunity_id) or (user_id+external_source+external_code); plans.key (Final Decision #1, #3).
- Indexes on high‑QPS lookups: opportunities(city_id, brand, model, year, price), ads_raw(source, fetched_at), chats(user_id, created_at) (Product Design §8 guidance; Final Decision #6).
 - New tables: plan_entitlements, user_quotas, addons, user_addons, wallet_ledger, trials, experiments, experiment_assignments, push_campaigns, push_logs, referral_links, referral_events, cancellations.

## External Integrations

- OpenAI Responses + file_search with structured JSON support (PRD §2, §7.4, §11 AI; Product Design §4.2, §9).
- majidapi endpoints for bama/divar (Product Design §5.1 with explicit URLs) (PRD §2 APIs, §5 ingestion).
- Zarinpal via shetabit/payment (PRD §2, §7.14; Implementation Plan §4).
- Telegram webhook via Telegraph (PRD §2 Tech Stack; Implementation Plan §2).
 - No external calls for Phase 2A (all stubs/local only).

## OPEN QUESTIONS

- City list/aliases source: provide seed list and aliases; no external API dependency declared (decision #6 confirms normalization but not source). Everything else resolved by decisions #1–#5.

— End of Checklist —
