# Roadmap 0 → Launch (Production-Ready)

## Scope
End-to-end plan to bring the bot to a secure, measurable, and fully functional production release. Based on current code, docs, and gaps observed.

## Milestones and Acceptance Criteria

1) Boot & Hardening (Blockers)
- Actions
  - Register `routes/telegraph.php` (RouteServiceProvider or `require` in routes/api.php)
  - Set Telegram webhook: `POST /api/telegram/webhook` + `secret_token`
  - Clear caches: route/config; ensure PHP ext-intl (Filament)
  - Queue tables: `queue:table && migrate`; Worker + Cron for `schedule:run`
  - Add DB index on `payments.ref`
- Acceptance
  - `route:list` shows `/telegram/webhook`; `getWebhookInfo` OK; worker/scheduler run; no 404/401 on webhook

2) Telegram Core & Onboarding
- Actions
  - Parse updates; handle `/start`, menu, onboarding (role, city alias search, budget, frequency)
  - Persist users (tg_id unique) and selections
  - Emit `Start`, `SelectCity`
- Acceptance
  - Onboarding completes; main menu DB-driven; events recorded

2.1) Phone Verification Gate (Optional)
- Actions
  - After onboarding, request contact via ReplyKeyboard `request_contact=true`; validate self-contact; store E.164; emit `PhoneSubmitted`
  - Toggle in Settings: require_phone_verification (hard/soft gate)
- Acceptance
  - Phone captured when enabled; gating policy enforced

2.2) Channel Membership Gate (Optional)
- Actions
  - Present list of required channels (from Settings); [✅ عضو شدم] handler verifies membership via `getChatMember`
  - Toggle in Settings: require_channel_membership; channels list configurable (title/chat_id/link)
- Acceptance
  - Membership enforced when enabled; pass recorded (`MembershipGatePassed`)

3) RBAC & Admin Access
- Actions
  - Publish/migrate spatie/permission; add `HasRoles` to User; seed roles; enforce `role:admin` on admin and Filament
- Acceptance
  - Admin-only endpoints/panel protected; non-admin gets 403

4) AI Valuation (Responses API + Memory + RAG)
- Actions
  - Implement `OpenAiProvider` HTTP calls with timeout/retry; store `previous_response_id` in `chat_threads`
  - `VectorStoreService`: attach/detach/status; use VS_MAIN/VS_IG
  - Persist `chats` (token/latency/response_id); emit `PriceCheck`
- Acceptance
  - Valid valuation JSON; p80 latency measurable; chat rows stored

5) Payments (shetabit/payment) E2E
- Actions
  - Implement `PaymentService` create/verify; use in controller; verify idempotent by authority/ref
  - Activate subscription; emit `UpgradeSuccess`; reconcile stale
- Acceptance
  - End-to-end happy path + idempotency proven; KPIs computable

6) Ads Ingestion & Pipeline
- Actions
  - `MajidApiClient` for bama/divar; Jobs write to `ads_raw`
  - `ScoreOpportunitiesJob` normalize→dedup→median→score→persist; TTL>72h archive
  - Affordable Ads listing with ⭐ save and links
- Acceptance
  - `opportunities` populated with scores/reasons; listing works

7) Push Campaigns & CTR
- Actions
  - Segment selection; send via Telegraph; record `push_logs.sent_at/delivered_at`; click telemetry
- Acceptance
  - CTR = clicks/delivered computable per campaign

8) Saved Ads & Tickets
- Actions
  - Saved Ads ownership + per-user uniqueness; `SaveDeal` event
  - Tickets user/admin reply; optional closing
- Acceptance
  - Full CRUD with ownership; saved/delivered ≥10% tracked

9) Filament Admin Panel
- Actions
  - Panel + Resources (Users/Plans/Subscriptions/Payments/Menu/Prompts/VectorStores/Files/Opportunities/FeaturedAds/ScrapeProfiles/Experiments/PushCampaigns/Logs/Addons/UserAddons/Trials/WalletLedger/ReferralLinks/Events/Cancellations)
  - KPI widgets (CTR, Saved/Delivered, D1 Activation, Payment success)
- Acceptance
  - Operators can manage content/data and observe KPIs

10) Analytics & KPI
- Actions
  - Emit events across flows: Start, SelectCity, ViewDeal, SaveDeal, CallFromCard, PriceCheck, ChecklistRun, PushOpen, UpgradeClick, UpgradeSuccess, CancelStart, CancelRescueSuccess, ReferralJoin
  - Add daily report
- Acceptance
  - All KPIs computable; quality gates met

11) Security & Ops
- Actions
  - Secret rotation; job idempotency/backoff; error handling; rate limits verified; simulate block in prod
- Acceptance
  - Baseline security checks pass; incidents containable

12) Testing & QA
- Actions
  - Feature/Integration tests for webhook, RBAC, payments, saved ads, AI, ads pipeline, simulate protect
  - Load tests for AI endpoints
- Acceptance
  - Green test suite; regression-safe releases

## Dependencies and Risks
- ext-intl required for Filament (hosting)
- MajidAPI availability and HTTP quotas
- OpenAI latency/costs
- Zarinpal sandbox/production stability

## Monitoring & Runbook
- See RUNBOOK.md for setup, and KPI_READINESS.md for queries.
