<x-filament-panels::page>
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-4 gap-6 mb-6">
        
        <!-- Total Users -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Users</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($dashboardStats['total_users'] ?? 0) }}</p>
                </div>
                <div class="p-3 bg-blue-100 rounded-full">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-sm text-gray-600">Active today: {{ number_format($dashboardStats['active_today'] ?? 0) }}</span>
            </div>
        </div>

        <!-- Messages Today -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Messages Today</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($dashboardStats['messages_today'] ?? 0) }}</p>
                </div>
                <div class="p-3 bg-green-100 rounded-full">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-sm text-gray-600">This week: {{ number_format($dashboardStats['messages_week'] ?? 0) }}</span>
            </div>
        </div>

        <!-- Callbacks Today -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Callbacks Today</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($dashboardStats['callbacks_today'] ?? 0) }}</p>
                </div>
                <div class="p-3 bg-yellow-100 rounded-full">
                    <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122"></path>
                    </svg>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-sm text-gray-600">This week: {{ number_format($dashboardStats['callbacks_week'] ?? 0) }}</span>
            </div>
        </div>

        <!-- Active Users -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active This Week</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($dashboardStats['active_week'] ?? 0) }}</p>
                </div>
                <div class="p-3 bg-purple-100 rounded-full">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-sm text-gray-600">Monthly: {{ number_format($userStats['active_month'] ?? 0) }}</span>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        
        <!-- User Analytics -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">User Analytics</h3>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">New Users Today</span>
                    <span class="font-medium">{{ number_format($userStats['new_users_today'] ?? 0) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">New Users This Week</span>
                    <span class="font-medium">{{ number_format($userStats['new_users_week'] ?? 0) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">Active Today</span>
                    <span class="font-medium">{{ number_format($userStats['active_today'] ?? 0) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">Active This Week</span>
                    <span class="font-medium">{{ number_format($userStats['active_week'] ?? 0) }}</span>
                </div>
            </div>

            @if(isset($userStats['top_users']) && !empty($userStats['top_users']))
            <div class="mt-6">
                <h4 class="text-sm font-medium text-gray-900 mb-3">Most Active Users</h4>
                <div class="space-y-2">
                    @foreach(array_slice($userStats['top_users'], 0, 5) as $topUser)
                    <div class="flex justify-between items-center text-sm">
                        <span class="text-gray-600">User {{ $topUser['user_id'] }}</span>
                        <span class="font-medium">{{ $topUser['activity_count'] }} events</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>

        <!-- Content Analytics -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Content Analytics</h3>
            
            @if(isset($contentStats['popular_commands']) && !empty($contentStats['popular_commands']))
            <div class="mb-6">
                <h4 class="text-sm font-medium text-gray-900 mb-3">Popular Commands</h4>
                <div class="space-y-2">
                    @foreach(array_slice($contentStats['popular_commands'], 0, 5) as $command)
                    <div class="flex justify-between items-center text-sm">
                        <span class="text-gray-600 font-mono">{{ $command['command'] }}</span>
                        <span class="font-medium">{{ number_format($command['count']) }}</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            @if(isset($contentStats['popular_callbacks']) && !empty($contentStats['popular_callbacks']))
            <div>
                <h4 class="text-sm font-medium text-gray-900 mb-3">Popular Callbacks</h4>
                <div class="space-y-2">
                    @foreach(array_slice($contentStats['popular_callbacks'], 0, 5) as $callback)
                    <div class="flex justify-between items-center text-sm">
                        <span class="text-gray-600 font-mono">{{ Str::limit($callback['callback'], 20) }}</span>
                        <span class="font-medium">{{ number_format($callback['count']) }}</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="mt-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Event Statistics</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-gray-900">{{ number_format($eventStats['total_events'] ?? 0) }}</div>
                    <div class="text-sm text-gray-600">Total Events</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-green-600">{{ number_format($eventStats['events_today'] ?? 0) }}</div>
                    <div class="text-sm text-gray-600">Events Today</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-blue-600">{{ number_format($eventStats['events_week'] ?? 0) }}</div>
                    <div class="text-sm text-gray-600">Events This Week</div>
                </div>
            </div>

            @if(isset($eventStats['top_events']) && !empty($eventStats['top_events']))
            <div class="mt-6">
                <h4 class="text-sm font-medium text-gray-900 mb-3">Event Types</h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @foreach($eventStats['top_events'] as $event)
                    <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                        <span class="text-sm font-medium text-gray-700">{{ ucfirst($event['type']) }}</span>
                        <span class="text-sm font-bold text-gray-900">{{ number_format($event['count']) }}</span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>

    @if(empty($dashboardStats))
    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6 text-center">
        <svg class="mx-auto h-12 w-12 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
        </svg>
        <h3 class="mt-2 text-sm font-medium text-yellow-800">No Analytics Data Available</h3>
        <p class="mt-1 text-sm text-yellow-600">Analytics data will appear here once users start interacting with your bot.</p>
        <div class="mt-6">
            <button wire:click="refreshData" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-yellow-700 bg-yellow-100 hover:bg-yellow-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                Refresh Data
            </button>
        </div>
    </div>
    @endif

</x-filament-panels::page>