<x-filament-panels::page>
    <div class="space-y-6">
        <!-- Real-time Metrics -->
        <x-filament-panels::section title="آمار لحظه‌ای" description="معیارهای کلیدی سیستم در زمان واقعی">
            <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                <div class="bg-white p-6 rounded-lg shadow-sm border">
                    <div class="flex items-center">
                        <div class="p-2 bg-blue-100 rounded-lg">
                            <x-heroicon-o-users class="w-6 h-6 text-blue-600" />
                        </div>
                        <div class="mr-4">
                            <div class="text-2xl font-bold text-gray-900">{{ $this->getTotalUsers() }}</div>
                            <div class="text-sm text-gray-500">کل کاربران</div>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-sm border">
                    <div class="flex items-center">
                        <div class="p-2 bg-green-100 rounded-lg">
                            <x-heroicon-o-check-circle class="w-6 h-6 text-green-600" />
                        </div>
                        <div class="mr-4">
                            <div class="text-2xl font-bold text-gray-900">{{ $this->getActiveUsers() }}</div>
                            <div class="text-sm text-gray-500">کاربران فعال (۷ روز)</div>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-sm border">
                    <div class="flex items-center">
                        <div class="p-2 bg-yellow-100 rounded-lg">
                            <x-heroicon-o-clock class="w-6 h-6 text-yellow-600" />
                        </div>
                        <div class="mr-4">
                            <div class="text-2xl font-bold text-gray-900">{{ $this->getPendingPayments() }}</div>
                            <div class="text-sm text-gray-500">پرداخت‌های در انتظار</div>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-sm border">
                    <div class="flex items-center">
                        <div class="p-2 bg-red-100 rounded-lg">
                            <x-heroicon-o-exclamation-triangle class="w-6 h-6 text-red-600" />
                        </div>
                        <div class="mr-4">
                            <div class="text-2xl font-bold text-gray-900">{{ $this->getRecentErrors() }}</div>
                            <div class="text-sm text-gray-500">خطاهای اخیر (۱ ساعت)</div>
                        </div>
                    </div>
                </div>
            </div>
        </x-filament-panels::section>

        <!-- Charts and Trends -->
        <div class="grid gap-6 md:grid-cols-2">
            <!-- User Registration Trend -->
            <x-filament-panels::section title="روند ثبت‌نام کاربران" description="ثبت‌نام روزانه در ۳۰ روز گذشته">
                <div class="h-64 flex items-center justify-center bg-gray-50 rounded-lg">
                    <div class="text-center text-gray-500">
                        <x-heroicon-o-chart-bar class="w-12 h-12 mx-auto mb-2" />
                        <div>نمودار روند ثبت‌نام</div>
                        <div class="text-sm">در نسخه‌های آینده اضافه خواهد شد</div>
                    </div>
                </div>
            </x-filament-panels::section>

            <!-- Payment Success Rate -->
            <x-filament-panels::section title="نرخ موفقیت پرداخت" description="آمار پرداخت‌ها در ۳۰ روز گذشته">
                <div class="space-y-4">
                    @php
                        $paymentStats = $this->getPaymentStats();
                    @endphp

                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium">موفق</span>
                        <span class="text-sm text-green-600">{{ $paymentStats['successful'] }} پرداخت</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div class="bg-green-600 h-2 rounded-full" style="width: {{ $paymentStats['success_rate'] }}%"></div>
                    </div>

                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium">ناموفق</span>
                        <span class="text-sm text-red-600">{{ $paymentStats['failed'] }} پرداخت</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div class="bg-red-600 h-2 rounded-full" style="width: {{ $paymentStats['fail_rate'] }}%"></div>
                    </div>

                    <div class="pt-2 border-t">
                        <div class="text-center">
                            <div class="text-2xl font-bold">{{ $paymentStats['success_rate'] }}%</div>
                            <div class="text-sm text-gray-500">نرخ موفقیت کلی</div>
                        </div>
                    </div>
                </div>
            </x-filament-panels::section>
        </div>

        <!-- Detailed Analytics -->
        <x-filament-panels::section title="آمار تفصیلی" description="جزئیات عملکرد سیستم">
            <div class="grid gap-6 md:grid-cols-3">
                <!-- CTR by Campaign -->
                <div class="space-y-4">
                    <h4 class="font-semibold text-gray-900">CTR کمپین‌ها (۷ روز گذشته)</h4>
                    @php
                        $campaignStats = $this->getCampaignStats();
                    @endphp

                    @if(empty($campaignStats))
                        <div class="text-center py-8 text-gray-500">
                            <x-heroicon-o-chart-pie class="w-8 h-8 mx-auto mb-2" />
                            <div>داده‌ای برای نمایش وجود ندارد</div>
                        </div>
                    @else
                        @foreach($campaignStats as $stat)
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div>
                                    <div class="font-medium">کمپین #{{ $stat['campaign_id'] }}</div>
                                    <div class="text-sm text-gray-500">{{ $stat['clicks'] }}/{{ $stat['delivered'] }}</div>
                                </div>
                                <div class="text-right">
                                    <div class="text-lg font-bold {{ $stat['ctr'] >= 25 ? 'text-green-600' : ($stat['ctr'] >= 15 ? 'text-yellow-600' : 'text-red-600') }}">
                                        {{ $stat['ctr'] }}%
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>

                <!-- Top Performing Cities -->
                <div class="space-y-4">
                    <h4 class="font-semibold text-gray-900">شهرهای برتر (۷ روز گذشته)</h4>
                    @php
                        $cityStats = $this->getCityStats();
                    @endphp

                    @if(empty($cityStats))
                        <div class="text-center py-8 text-gray-500">
                            <x-heroicon-o-map-pin class="w-8 h-8 mx-auto mb-2" />
                            <div>داده‌ای برای نمایش وجود ندارد</div>
                        </div>
                    @else
                        @foreach($cityStats as $stat)
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div>
                                    <div class="font-medium">{{ $stat['city'] }}</div>
                                    <div class="text-sm text-gray-500">{{ $stat['opportunities'] }} فرصت</div>
                                </div>
                                <div class="text-right">
                                    <div class="text-lg font-bold text-blue-600">{{ $stat['saved'] }}</div>
                                    <div class="text-sm text-gray-500">ذخیره شده</div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>

                <!-- AI Usage Stats -->
                <div class="space-y-4">
                    <h4 class="font-semibold text-gray-900">استفاده از AI (۷ روز گذشته)</h4>
                    @php
                        $aiStats = $this->getAiStats();
                    @endphp

                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center p-3 bg-blue-50 rounded-lg">
                            <div class="text-2xl font-bold text-blue-600">{{ $aiStats['requests'] }}</div>
                            <div class="text-sm text-gray-600">درخواست</div>
                        </div>
                        <div class="text-center p-3 bg-green-50 rounded-lg">
                            <div class="text-2xl font-bold text-green-600">{{ number_format($aiStats['avg_latency'], 1) }}ms</div>
                            <div class="text-sm text-gray-600">میانگین تأخیر</div>
                        </div>
                        <div class="text-center p-3 bg-yellow-50 rounded-lg">
                            <div class="text-2xl font-bold text-yellow-600">{{ $aiStats['tokens'] }}</div>
                            <div class="text-sm text-gray-600">توکن مصرفی</div>
                        </div>
                        <div class="text-center p-3 bg-red-50 rounded-lg">
                            <div class="text-2xl font-bold text-red-600">{{ $aiStats['errors'] }}</div>
                            <div class="text-sm text-gray-600">خطا</div>
                        </div>
                    </div>
                </div>
            </div>
        </x-filament-panels::section>
    </div>
</x-filament-panels::page>

