<x-filament-panels::page>
    <div class="space-y-6">
        <!-- Feature Toggles -->
        <x-filament-panels::section title="تنظیمات ویژگی‌ها" description="فعال/غیرفعال کردن قابلیت‌های مختلف سیستم">
            <div class="grid gap-6 md:grid-cols-2">
                <x-filament::field-wrapper>
                    <x-filament::field.label>
                        نیاز به تأیید شماره تلفن
                    </x-filament::field.label>
                    <x-filament::input.checkbox
                        wire:model="require_phone_verification"
                        wire:change="updateSetting('require_phone_verification', $event.target.checked)"
                    />
                    <x-filament::field.helper-text>
                        کاربران باید شماره تلفن خود را تأیید کنند
                    </x-filament::field.helper-text>
                </x-filament-panels::field>

                <x-filament::field-wrapper>
                    <x-filament::field.label>
                        نیاز به عضویت در کانال
                    </x-filament::field.label>
                    <x-filament::input.checkbox
                        wire:model="require_channel_membership"
                        wire:change="updateSetting('require_channel_membership', $event.target.checked)"
                    />
                    <x-filament::field.helper-text>
                        کاربران باید در کانال‌های مشخص عضو شوند
                    </x-filament::field.helper-text>
                </x-filament-panels::field>

                <x-filament::field-wrapper>
                    <x-filament::field.label>
                        سیاست تأیید تلفن
                    </x-filament::field.label>
                    <select
                        wire:model="phone_gate_policy"
                        wire:change="updateSetting('phone_gate_policy', $event.target.value)"
                        class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-primary-500 focus:border-primary-500"
                    >
                        <option value="hard_gate">سخت - مسدود کردن کامل</option>
                        <option value="soft_gate">نرم - دسترسی محدود</option>
                    </select>
                    <x-filament::field.helper-text>
                        نحوه رفتار سیستم با کاربران بدون تأیید تلفن
                    </x-filament::field.helper-text>
                </x-filament-panels::field>
            </div>
        </x-filament-panels::section>

        <!-- Channel Management -->
        <x-filament-panels::section title="مدیریت کانال‌ها" description="کانال‌های تلگرامی که کاربران باید عضو شوند">
            <div class="space-y-4">
                <div wire:poll.10s>
                    @foreach($channels as $index => $channel)
                        <div class="flex items-center gap-4 p-4 bg-gray-50 rounded-lg">
                            <div class="flex-1">
                                <div class="font-medium">{{ $channel['title'] ?? 'کانال ' . ($index + 1) }}</div>
                                <div class="text-sm text-gray-600">@{{ $channel['chat_id'] }}</div>
                            </div>
                            <div class="flex items-center gap-2">
                                <a href="{{ $channel['link'] }}" target="_blank" class="text-blue-600 hover:text-blue-800">
                                    <x-heroicon-o-link class="w-5 h-5" />
                                </a>
                                <button
                                    wire:click="testChannel({{ $index }})"
                                    class="text-green-600 hover:text-green-800"
                                    title="تست عضویت"
                                >
                                    <x-heroicon-o-check-circle class="w-5 h-5" />
                                </button>
                                <button
                                    wire:click="removeChannel({{ $index }})"
                                    class="text-red-600 hover:text-red-800"
                                    title="حذف"
                                >
                                    <x-heroicon-o-trash class="w-5 h-5" />
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Add New Channel -->
                <div class="border-2 border-dashed border-gray-300 rounded-lg p-6">
                    <div class="text-center">
                        <x-heroicon-o-plus-circle class="w-12 h-12 text-gray-400 mx-auto mb-4" />
                        <h3 class="text-lg font-medium text-gray-900 mb-2">افزودن کانال جدید</h3>
                        <form wire:submit.prevent="addChannel" class="space-y-4">
                            <div>
                                <x-filament::input.wrapper>
                                    <x-filament::input
                                        wire:model="newChannel.title"
                                        placeholder="عنوان کانال"
                                        required
                                    />
                                </x-filament::input.wrapper>
                            </div>
                            <div>
                                <x-filament::input.wrapper>
                                    <x-filament::input
                                        wire:model="newChannel.chat_id"
                                        placeholder="@channel_username یا chat_id"
                                        required
                                    />
                                </x-filament::input.wrapper>
                            </div>
                            <div>
                                <x-filament::input.wrapper>
                                    <x-filament::input
                                        wire:model="newChannel.link"
                                        placeholder="لینک عضویت"
                                        type="url"
                                        required
                                    />
                                </x-filament::input.wrapper>
                            </div>
                            <x-filament::button type="submit" color="primary">
                                افزودن کانال
                            </x-filament::button>
                        </form>
                    </div>
                </div>
            </div>
        </x-filament-panels::section>

        <!-- Webhook Testing -->
        <x-filament-panels::section title="تست سیستم" description="ابزارهای تست و بررسی عملکرد">
            <div class="grid gap-4 md:grid-cols-2">
                <x-filament::button
                    wire:click="testWebhook"
                    color="gray"
                    class="w-full"
                >
                    <x-heroicon-o-arrow-path class="w-4 h-4 mr-2" />
                    تست وب‌هوک
                </x-filament::button>

                <x-filament::button
                    wire:click="testMembership"
                    color="gray"
                    class="w-full"
                >
                    <x-heroicon-o-user-group class="w-4 h-4 mr-2" />
                    تست عضویت
                </x-filament::button>
            </div>

            @if($testResult)
                <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                    <pre class="text-sm">{{ json_encode($testResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                </div>
            @endif
        </x-filament-panels::section>
    </div>
</x-filament-panels::page>

