<x-filament-panels::page>
    <div x-data="{ 
        autoRefresh: @entangle('autoRefresh'),
        refreshInterval: null,
        initAutoRefresh() {
            this.$watch('autoRefresh', value => {
                if (value) {
                    this.startAutoRefresh();
                } else {
                    this.stopAutoRefresh();
                }
            });
        },
        startAutoRefresh() {
            this.refreshInterval = setInterval(() => {
                $wire.refreshHealthData();
            }, 30000); // 30 seconds
        },
        stopAutoRefresh() {
            if (this.refreshInterval) {
                clearInterval(this.refreshInterval);
                this.refreshInterval = null;
            }
        }
    }" 
    x-init="initAutoRefresh()"
    @health-data-refreshed.window="console.log('Health data refreshed')"
    @start-auto-refresh.window="startAutoRefresh()"
    @stop-auto-refresh.window="stopAutoRefresh()">

    <!-- Overall Status Card -->
    <div class="mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">System Health Status</h2>
                    <p class="text-sm text-gray-600 mt-1">Last updated: {{ now()->format('Y-m-d H:i:s') }}</p>
                </div>
                <div class="flex items-center space-x-3">
                    @php
                        $status = $this->getOverallStatus();
                        $color = $this->getOverallStatusColor();
                    @endphp
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-4 rounded-full 
                            {{ $color === 'success' ? 'bg-green-500' : '' }}
                            {{ $color === 'warning' ? 'bg-yellow-500' : '' }}
                            {{ $color === 'danger' ? 'bg-red-500' : '' }}
                            {{ $color === 'gray' ? 'bg-gray-500' : '' }}
                        "></div>
                        <span class="text-lg font-semibold capitalize 
                            {{ $color === 'success' ? 'text-green-700' : '' }}
                            {{ $color === 'warning' ? 'text-yellow-700' : '' }}
                            {{ $color === 'danger' ? 'text-red-700' : '' }}
                            {{ $color === 'gray' ? 'text-gray-700' : '' }}
                        ">{{ ucfirst($status) }}</span>
                    </div>
                </div>
            </div>

            <!-- Summary Stats -->
            @php $summary = $this->getSummary(); @endphp
            <div class="grid grid-cols-4 gap-4 mt-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-gray-900">{{ $summary['total_checks'] }}</div>
                    <div class="text-sm text-gray-600">Total Checks</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-green-600">{{ $summary['healthy'] }}</div>
                    <div class="text-sm text-gray-600">Healthy</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-yellow-600">{{ $summary['warning'] }}</div>
                    <div class="text-sm text-gray-600">Warnings</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-red-600">{{ $summary['error'] }}</div>
                    <div class="text-sm text-gray-600">Errors</div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Metrics -->
    @php $metrics = $this->getSystemMetrics(); @endphp
    @if(!empty($metrics))
    <div class="mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">System Metrics</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                
                <!-- Database Metrics -->
                @isset($metrics['database'])
                <div class="space-y-3">
                    <h4 class="font-medium text-gray-700">Database</h4>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Connection Time:</span>
                            <span class="font-medium">{{ $metrics['database']['connection_time'] }}ms</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Total Users:</span>
                            <span class="font-medium">{{ number_format($metrics['database']['total_users']) }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Active (24h):</span>
                            <span class="font-medium">{{ number_format($metrics['database']['active_users_24h']) }}</span>
                        </div>
                    </div>
                </div>
                @endisset

                <!-- System Resources -->
                @isset($metrics['system'])
                <div class="space-y-3">
                    <h4 class="font-medium text-gray-700">System Resources</h4>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Memory Usage:</span>
                            <span class="font-medium">{{ $metrics['system']['memory_usage_mb'] }}MB ({{ $metrics['system']['memory_usage_percent'] }}%)</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">PHP Version:</span>
                            <span class="font-medium">{{ $metrics['system']['php_version'] }}</span>
                        </div>
                    </div>
                </div>
                @endisset

                <!-- Storage Metrics -->
                @isset($metrics['storage'])
                <div class="space-y-3">
                    <h4 class="font-medium text-gray-700">Storage</h4>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Free Space:</span>
                            <span class="font-medium">{{ $metrics['storage']['free_space_gb'] }}GB</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Usage:</span>
                            <span class="font-medium">{{ $metrics['storage']['usage_percent'] }}%</span>
                        </div>
                    </div>
                </div>
                @endisset

            </div>
        </div>
    </div>
    @endif

    <!-- Health Check Details -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        @foreach($this->getChecks() as $checkName => $check)
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900 capitalize">
                    {{ str_replace('_', ' ', $checkName) }}
                </h3>
                <div class="flex items-center space-x-2">
                    @php
                        $statusColor = $this->getCheckStatusColor($check['status']);
                        $statusIcon = $this->getCheckStatusIcon($check['status']);
                    @endphp
                    <x-heroicon-o-check-circle 
                        @class([
                            'w-5 h-5',
                            'text-green-500' => $statusColor === 'success',
                            'text-yellow-500' => $statusColor === 'warning', 
                            'text-red-500' => $statusColor === 'danger',
                            'text-gray-500' => $statusColor === 'gray',
                            'hidden' => $check['status'] !== 'healthy'
                        ])
                    />
                    <x-heroicon-o-exclamation-triangle 
                        @class([
                            'w-5 h-5',
                            'text-yellow-500' => $statusColor === 'warning',
                            'hidden' => $check['status'] !== 'warning'
                        ])
                    />
                    <x-heroicon-o-x-circle 
                        @class([
                            'w-5 h-5',
                            'text-red-500' => $statusColor === 'danger',
                            'hidden' => $check['status'] !== 'error'
                        ])
                    />
                    <span class="text-sm font-medium capitalize 
                        {{ $statusColor === 'success' ? 'text-green-700' : '' }}
                        {{ $statusColor === 'warning' ? 'text-yellow-700' : '' }}
                        {{ $statusColor === 'danger' ? 'text-red-700' : '' }}
                        {{ $statusColor === 'gray' ? 'text-gray-700' : '' }}
                    ">{{ $check['status'] }}</span>
                </div>
            </div>

            <p class="text-gray-700 mb-3">{{ $check['message'] }}</p>

            <div class="text-xs text-gray-500 mb-3">
                Duration: {{ $check['duration_ms'] }}ms | 
                Updated: {{ \Carbon\Carbon::parse($check['timestamp'])->format('H:i:s') }}
            </div>

            @if(!empty($check['details']))
            <div class="border-t pt-3">
                <h4 class="text-sm font-medium text-gray-700 mb-2">Details</h4>
                <div class="space-y-1 text-sm">
                    @foreach($check['details'] as $key => $value)
                    <div class="flex justify-between">
                        <span class="text-gray-600 capitalize">{{ str_replace('_', ' ', $key) }}:</span>
                        <span class="font-medium text-right ml-2">
                            @if(is_bool($value))
                                {{ $value ? 'Yes' : 'No' }}
                            @elseif(is_array($value))
                                @if(empty($value))
                                    <em class="text-gray-400">Empty</em>
                                @else
                                    <details class="inline">
                                        <summary class="cursor-pointer text-blue-600">{{ count($value) }} items</summary>
                                        <div class="mt-1 text-xs bg-gray-50 p-2 rounded">
                                            @foreach($value as $item)
                                                @if(is_array($item))
                                                    <div>{{ json_encode($item) }}</div>
                                                @else
                                                    <div>{{ $item }}</div>
                                                @endif
                                            @endforeach
                                        </div>
                                    </details>
                                @endif
                            @else
                                {{ $value }}
                            @endif
                        </span>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
        @endforeach
    </div>

    <!-- Auto Refresh Indicator -->
    <div x-show="autoRefresh" 
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         class="fixed bottom-4 right-4 bg-blue-500 text-white px-4 py-2 rounded-lg shadow-lg flex items-center space-x-2">
        <div class="w-2 h-2 bg-white rounded-full animate-pulse"></div>
        <span class="text-sm">Auto-refreshing every 30s</span>
    </div>

</x-filament-panels::page>