<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتیجه پرداخت</title>
    <style>
        body {
            font-family: 'Tahoma', 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            padding: 20px;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        .icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            color: white;
        }
        .success {
            background: #4CAF50;
        }
        .error {
            background: #f44336;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 24px;
        }
        .message {
            color: #666;
            margin-bottom: 30px;
            font-size: 16px;
            line-height: 1.6;
        }
        .details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: right;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }
        .label {
            font-weight: bold;
            color: #333;
        }
        .value {
            color: #666;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 25px;
            font-weight: bold;
            transition: background 0.3s;
        }
        .btn:hover {
            background: #5a6fd8;
        }
        .telegram-btn {
            background: #0088cc;
            margin-right: 10px;
        }
        .telegram-btn:hover {
            background: #006699;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon {{ $success ? 'success' : 'error' }}">
            {{ $success ? '✓' : '✗' }}
        </div>

        <h1>{{ $success ? 'پرداخت موفق' : 'پرداخت ناموفق' }}</h1>
        
        <div class="message">
            {{ $message }}
        </div>

        @if($payment)
        <div class="details">
            <div class="detail-row">
                <span class="label">کد رهگیری:</span>
                <span class="value">{{ $payment->tracking_code }}</span>
            </div>
            <div class="detail-row">
                <span class="label">مبلغ:</span>
                <span class="value">{{ number_format($payment->amount) }} تومان</span>
            </div>
            <div class="detail-row">
                <span class="label">تاریخ:</span>
                <span class="value">{{ $payment->created_at->format('Y/m/d H:i') }}</span>
            </div>
            @if($success && isset($reference_id))
            <div class="detail-row">
                <span class="label">شماره مرجع:</span>
                <span class="value">{{ $reference_id }}</span>
            </div>
            @endif
            <div class="detail-row">
                <span class="label">وضعیت:</span>
                <span class="value">{{ $payment->status_label }}</span>
            </div>
        </div>
        @endif

        <div style="margin-top: 30px;">
            <a href="https://t.me/{{ config('telegram.bot_username', 'your_bot') }}" class="btn telegram-btn">
                بازگشت به ربات
            </a>
            <a href="javascript:window.close()" class="btn">
                بستن صفحه
            </a>
        </div>

        @if($success)
        <script>
            // Auto close after 10 seconds for successful payments
            setTimeout(function() {
                window.close();
            }, 10000);
        </script>
        @endif
    </div>
</body>
</html>