<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AIController;
use App\Http\Controllers\PaymentsController;
use App\Http\Controllers\SavedAdsController;
use App\Http\Controllers\Support\TicketsController;
use App\Http\Controllers\Admin\TicketsController as AdminTicketsController;
use App\Http\Controllers\Admin\OpportunitiesController;
use App\Http\Controllers\Admin\FeaturedAdsController;
use App\Http\Controllers\SimulateController;
use App\Http\Controllers\InspectionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

/*
|--------------------------------------------------------------------------
| AI Routes (Rate Limited)
|--------------------------------------------------------------------------
*/
Route::middleware(['rate_limit_per_user:5,1'])->group(function () {
    Route::post('/ai/respond', [AIController::class, 'respond'])->middleware('feature.guard:pricecheck');
});

/*
|--------------------------------------------------------------------------
| Payments Routes
|--------------------------------------------------------------------------
*/
Route::post('/payments/create', [PaymentsController::class, 'create']);
Route::get('/payments/verify', [PaymentsController::class, 'verify']);
Route::post('/payments/reconcile', [PaymentsController::class, 'reconcile']);

/*
|--------------------------------------------------------------------------
| User Saved Ads Routes
|--------------------------------------------------------------------------
*/
Route::get('/user/saved_ads', [SavedAdsController::class, 'index'])->middleware('feature.guard:view_deals');
Route::post('/user/saved_ads', [SavedAdsController::class, 'store']);
Route::delete('/user/saved_ads/{id}', [SavedAdsController::class, 'destroy']);

/*
|--------------------------------------------------------------------------
| Support Tickets Routes
|--------------------------------------------------------------------------
*/
Route::post('/support/tickets', [TicketsController::class, 'store']);
Route::get('/support/tickets', [TicketsController::class, 'index']);

/*
|--------------------------------------------------------------------------
| Admin Routes (Protected)
|--------------------------------------------------------------------------
*/
Route::middleware(['role:admin'])->prefix('admin')->group(function () {
    Route::post('/tickets/{id}/reply', [AdminTicketsController::class, 'reply']);
    Route::post('/opportunities/push', [OpportunitiesController::class, 'push'])->middleware('feature.guard:instant_push');
    Route::post('/featured_ads/push', [FeaturedAdsController::class, 'push'])->middleware('feature.guard:instant_push');
    Route::get('/opportunities', [OpportunitiesController::class, 'index']);
});

/*
|--------------------------------------------------------------------------
| Simulation Routes (Local Only)
|--------------------------------------------------------------------------
*/
Route::post('/simulate/click', [SimulateController::class, 'click'])->middleware('simulate.protect');

/*
|--------------------------------------------------------------------------
| Inspection Routes (Protected)
|--------------------------------------------------------------------------
*/
Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('inspection')->group(function () {
        Route::post('/start', [InspectionController::class, 'start']);
        Route::post('/{inspection}/answer', [InspectionController::class, 'answer']);
        Route::get('/{inspection}', [InspectionController::class, 'show']);
        Route::get('/{inspection}/progress', [InspectionController::class, 'progress']);
        Route::post('/{inspection}/cancel', [InspectionController::class, 'cancel']);
    });
});

/*
|--------------------------------------------------------------------------
| Telegram Webhook Routes
|--------------------------------------------------------------------------
| Laravel does not auto-load custom route files. Load telegraph routes here
| so that POST /telegram/webhook is registered and does not return 404.
*/
require __DIR__ . '/telegraph.php';
