<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PaymentCallbackController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Payment Routes
Route::prefix('payment')->name('payment.')->group(function () {
    Route::get('callback/{tracking_code}', [PaymentCallbackController::class, 'callback'])->name('callback');
    Route::get('status/{tracking_code}', [PaymentCallbackController::class, 'status'])->name('status');
});
